/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.minecraft;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.handlers.dependencyInjection.ModAccessorHandler;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.lod.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import forge.com.seibel.lod.common.wrappers.WrapperFactory;
import forge.com.seibel.lod.common.wrappers.block.BlockPosWrapper;
import forge.com.seibel.lod.common.wrappers.minecraft.MinecraftClientWrapper;
import forge.com.seibel.lod.common.wrappers.misc.LightMapWrapper;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Color;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.opengl.GL15;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final GameRenderer GAME_RENDERER = MinecraftRenderWrapper.MC.field_71460_t;
    private static final IWrapperFactory FACTORY = WrapperFactory.INSTANCE;
    public LightMapWrapper lightmap = null;
    public boolean usingBackupGetVanillaRenderedChunks = false;

    @Override
    public Vec3f getLookAtVector() {
        ActiveRenderInfo camera = GAME_RENDERER.func_215316_n();
        Vector3f cameraDir = camera.func_227996_l_();
        return new Vec3f(cameraDir.func_195899_a(), cameraDir.func_195900_b(), cameraDir.func_195902_c());
    }

    @Override
    public AbstractBlockPosWrapper getCameraBlockPosition() {
        ActiveRenderInfo camera = GAME_RENDERER.func_215316_n();
        BlockPos blockPos = camera.func_216780_d();
        return new BlockPosWrapper(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    @Override
    public boolean playerHasBlindnessEffect() {
        return MinecraftRenderWrapper.MC.field_71439_g.func_193076_bZ().get(Effects.field_76440_q) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        ActiveRenderInfo camera = GAME_RENDERER.func_215316_n();
        Vector3d projectedView = camera.func_216785_c();
        return new Vec3d(projectedView.field_72450_a, projectedView.field_72448_b, projectedView.field_72449_c);
    }

    @Override
    public Mat4f getDefaultProjectionMatrix(float partialTicks) {
        return McObjectConverter.Convert(GAME_RENDERER.func_228382_a_(GAME_RENDERER.func_215316_n(), partialTicks, true));
    }

    @Override
    public double getGamma() {
        return MinecraftRenderWrapper.MC.field_71474_y.field_74333_Y;
    }

    @Override
    public Color getFogColor(float partialTicks) {
        float[] colorValues = new float[4];
        GL15.glGetFloatv((int)2918, (float[])colorValues);
        return new Color(colorValues[0], colorValues[1], colorValues[2], colorValues[3]);
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.field_71441_e.func_230315_m_().func_218272_d()) {
            Vector3d colorValues = MinecraftRenderWrapper.MC.field_71441_e.func_228318_a_(MinecraftRenderWrapper.MC.field_71460_t.func_215316_n().func_216780_d(), MC.func_184121_ak());
            return new Color((float)colorValues.field_72450_a, (float)colorValues.field_72448_b, (float)colorValues.field_72449_c);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return GAME_RENDERER.func_215311_a(GAME_RENDERER.func_215316_n(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.field_71474_y.field_151451_c;
    }

    @Override
    public int getScreenWidth() {
        return MC.func_228018_at_().func_198109_k();
    }

    @Override
    public int getScreenHeight() {
        return MC.func_228018_at_().func_198091_l();
    }

    private Framebuffer getRenderTarget() {
        Framebuffer r = null;
        return r != null ? r : MC.func_147110_a();
    }

    @Override
    public int getTargetFrameBuffer() {
        return this.getRenderTarget().field_147616_f;
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().field_147621_c;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().field_147618_d;
    }

    @Override
    public HashSet<AbstractChunkPosWrapper> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorHandler.get(ISodiumAccessor.class);
        if (sodium != null) {
            return sodium.getNormalRenderedChunks();
        }
        IOptifineAccessor optifine = ModAccessorHandler.get(IOptifineAccessor.class);
        if (optifine != null) {
            HashSet<AbstractChunkPosWrapper> pos = optifine.getNormalRenderedChunks();
            if (pos == null) {
                pos = this.getMaximumRenderedChunks();
            }
            return pos;
        }
        if (!this.usingBackupGetVanillaRenderedChunks) {
            try {
                WorldRenderer levelRenderer = MinecraftRenderWrapper.MC.field_71438_f;
                ObjectList chunks = levelRenderer.field_72755_R;
                return chunks.stream().map(chunk -> {
                    AxisAlignedBB chunkBoundingBox = chunk.field_178036_a.field_178591_c;
                    return FACTORY.createChunkPos(Math.floorDiv((int)chunkBoundingBox.field_72340_a, 16), Math.floorDiv((int)chunkBoundingBox.field_72339_c, 16));
                }).collect(Collectors.toCollection(HashSet::new));
            }
            catch (LinkageError e) {
                try {
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7e\u00a7l\u00a7uWARNING: Distant Horizons: getVanillaRenderedChunks method failed. Using Backup Method.");
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7eOverdraw prevention will be worse than normal.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ApiShared.LOGGER.error("getVanillaRenderedChunks Error: ", (Throwable)e);
                this.usingBackupGetVanillaRenderedChunks = true;
            }
        }
        return this.getMaximumRenderedChunks();
    }

    @Override
    public ILightMapWrapper getLightmapWrapper() {
        return this.lightmap;
    }

    @Override
    public boolean isFogStateSpecial() {
        ActiveRenderInfo camera = GAME_RENDERER.func_215316_n();
        FluidState fluidState = camera.func_216771_k();
        Entity entity = camera.func_216773_g();
        boolean isUnderWater = entity instanceof LivingEntity && ((LivingEntity)entity).func_70644_a(Effects.field_76440_q);
        isUnderWater |= fluidState.func_206884_a((ITag)FluidTags.field_206959_a);
        return isUnderWater |= fluidState.func_206884_a((ITag)FluidTags.field_206960_b);
    }

    @Override
    public boolean tryDisableVanillaFog() {
        return true;
    }

    public void updateLightmap(NativeImage lightPixels) {
        if (this.lightmap == null) {
            this.lightmap = new LightMapWrapper();
        }
        this.lightmap.uploadLightmap(lightPixels);
    }
}

