/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.world;

import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.world.biome.Biome;

public class BiomeWrapper
implements IBiomeWrapper {
    public static final ConcurrentMap<Biome, BiomeWrapper> biomeWrapperMap = new ConcurrentHashMap<Biome, BiomeWrapper>();
    private final Biome biome;

    public BiomeWrapper(Biome biome) {
        this.biome = biome;
    }

    public static IBiomeWrapper getBiomeWrapper(Biome biome) {
        if (biomeWrapperMap.containsKey(biome) && biomeWrapperMap.get(biome) != null) {
            return (IBiomeWrapper)biomeWrapperMap.get(biome);
        }
        BiomeWrapper biomeWrapper = new BiomeWrapper(biome);
        biomeWrapperMap.put(biome, biomeWrapper);
        return biomeWrapper;
    }

    @Override
    public int getColorForBiome(int x, int z) {
        int colorInt;
        switch (this.biome.field_201877_au) {
            case NETHER: {
                colorInt = Blocks.field_150424_aL.func_176223_P().func_185904_a().func_151565_r().field_76291_p;
                break;
            }
            case THEEND: {
                colorInt = Blocks.field_150377_bs.func_176223_P().func_185904_a().func_151565_r().field_76291_p;
                break;
            }
            case BEACH: 
            case DESERT: {
                colorInt = Blocks.field_150354_m.func_176223_P().func_185904_a().func_151565_r().field_76291_p;
                break;
            }
            case EXTREME_HILLS: {
                colorInt = Blocks.field_150348_b.func_235697_s_().field_76291_p;
                break;
            }
            case MUSHROOM: {
                colorInt = MaterialColor.field_197656_x.field_76291_p;
                break;
            }
            case ICY: {
                colorInt = Blocks.field_150433_aE.func_235697_s_().field_76291_p;
                break;
            }
            case MESA: {
                colorInt = Blocks.field_196611_F.func_235697_s_().field_76291_p;
                break;
            }
            case OCEAN: 
            case RIVER: {
                colorInt = this.biome.func_185361_o();
                break;
            }
            default: {
                colorInt = this.biome.func_225528_a_((double)x, (double)z);
            }
        }
        return colorInt;
    }

    @Override
    public String getName() {
        return this.biome.toString();
    }

    @Override
    public int getGrassTint(int x, int z) {
        return this.biome.func_225528_a_((double)x, (double)z);
    }

    @Override
    public int getFolliageTint() {
        return this.biome.func_225527_a_();
    }

    @Override
    public int getWaterTint() {
        return this.biome.func_185361_o();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BiomeWrapper)) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }
}

