/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvionmentWrapper;
import forge.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import forge.com.seibel.lod.common.wrappers.worldGeneration.ThreadedParameters;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.ChunkPos;

public final class GenerationEvent {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static int generationFutureDebugIDs = 0;
    final ThreadedParameters tParam;
    final ChunkPos pos;
    final int range;
    final Future<?> future;
    long creationNanotime;
    final int id;
    final AbstractBatchGenerationEnvionmentWrapper.Steps target;
    final LightGenerationMode lightMode;
    final BatchGenerationEnvironment.PrefEvent pEvent = new BatchGenerationEnvironment.PrefEvent();
    final boolean genAllDetails;
    final double runTimeRatio;

    public GenerationEvent(ChunkPos pos, int range, BatchGenerationEnvironment generationGroup, AbstractBatchGenerationEnvionmentWrapper.Steps target, boolean genAllDetails, double runTimeRatio) {
        LightGenerationMode mode;
        this.creationNanotime = System.nanoTime();
        this.pos = pos;
        this.range = range;
        this.id = generationFutureDebugIDs++;
        this.target = target;
        this.tParam = ThreadedParameters.getOrMake(generationGroup.params);
        this.lightMode = mode = CONFIG.client().worldGenerator().getLightGenerationMode();
        this.genAllDetails = genAllDetails;
        this.runTimeRatio = runTimeRatio;
        this.future = generationGroup.executors.submit(() -> {
            long startTime = System.nanoTime();
            BatchGenerationEnvironment.isDistantGeneratorThread.set(true);
            try {
                generationGroup.generateLodFromList(this);
            }
            finally {
                BatchGenerationEnvironment.isDistantGeneratorThread.remove();
                if (!Thread.interrupted() && runTimeRatio < 1.0) {
                    long endTime = System.nanoTime();
                    try {
                        long deltaMs = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
                        Thread.sleep((long)((double)deltaMs / runTimeRatio - (double)deltaMs));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    public boolean isCompleted() {
        return this.future.isDone();
    }

    public boolean hasTimeout(int duration, TimeUnit unit) {
        long currentTime = System.nanoTime();
        long delta = currentTime - this.creationNanotime;
        return delta > TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    public boolean terminate() {
        ApiShared.LOGGER.info("======================DUMPING ALL THREADS FOR WORLD GEN=======================");
        BatchGenerationEnvironment.threadFactory.dumpAllThreadStacks();
        this.future.cancel(true);
        return this.future.isCancelled();
    }

    public void join() {
        try {
            this.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getCause() == null ? e : e.getCause());
        }
    }

    public boolean tooClose(int cx, int cz, int cr) {
        int distX = Math.abs(cx - this.pos.field_77276_a);
        int distZ = Math.abs(cz - this.pos.field_77275_b);
        int minRange = cr + this.range + 1;
        return distX < (minRange += 2) && distZ < minRange;
    }

    public void refreshTimeout() {
        this.creationNanotime = System.nanoTime();
        LodUtil.checkInterruptsUnchecked();
    }

    public String toString() {
        return this.id + ":" + this.range + "@" + this.pos + "(" + (Object)((Object)this.target) + ")";
    }
}

