/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.BlockLightEngine;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.lighting.SkyLightEngine;
import net.minecraft.world.lighting.WorldLightManager;
import org.jetbrains.annotations.Nullable;

public class WorldGenLevelLightEngine
extends WorldLightManager {
    public static final int MAX_SOURCE_LEVEL = 15;
    public static final int LIGHT_SECTION_PADDING = 1;
    @Nullable
    public final BlockLightEngine blockEngine;
    @Nullable
    public final SkyLightEngine skyEngine;

    public WorldGenLevelLightEngine(LightGetterAdaptor genRegion) {
        super((IChunkLightProvider)genRegion, false, false);
        this.blockEngine = new BlockLightEngine((IChunkLightProvider)genRegion);
        this.skyEngine = new SkyLightEngine((IChunkLightProvider)genRegion);
    }

    public void func_215568_a(BlockPos blockPos) {
        if (this.blockEngine != null) {
            this.blockEngine.func_215617_a(blockPos);
        }
        if (this.skyEngine != null) {
            this.skyEngine.func_215617_a(blockPos);
        }
    }

    public void func_215573_a(BlockPos blockPos, int i) {
        if (this.blockEngine != null) {
            this.blockEngine.func_215623_a(blockPos, i);
        }
    }

    public boolean func_215570_a() {
        if (this.skyEngine != null && this.skyEngine.func_215619_a()) {
            return true;
        }
        return this.blockEngine != null && this.blockEngine.func_215619_a();
    }

    public int func_215575_a(int i, boolean bl, boolean bl2) {
        if (this.blockEngine != null && this.skyEngine != null) {
            int j = i / 2;
            int k = this.blockEngine.func_215616_a(j, bl, bl2);
            int l = i - j + k;
            int m = this.skyEngine.func_215616_a(l, bl, bl2);
            if (k == 0 && m > 0) {
                return this.blockEngine.func_215616_a(m, bl, bl2);
            }
            return m;
        }
        if (this.blockEngine != null) {
            return this.blockEngine.func_215616_a(i, bl, bl2);
        }
        if (this.skyEngine != null) {
            return this.skyEngine.func_215616_a(i, bl, bl2);
        }
        return i;
    }

    public void func_215566_a(SectionPos sectionPos, boolean bl) {
        if (this.blockEngine != null) {
            this.blockEngine.func_215566_a(sectionPos, bl);
        }
        if (this.skyEngine != null) {
            this.skyEngine.func_215566_a(sectionPos, bl);
        }
    }

    public void func_215571_a(ChunkPos chunkPos, boolean bl) {
        if (this.blockEngine != null) {
            this.blockEngine.func_215620_a(chunkPos, bl);
        }
        if (this.skyEngine != null) {
            this.skyEngine.func_215620_a(chunkPos, bl);
        }
    }

    public IWorldLightListener func_215569_a(LightType lightLayer) {
        if (lightLayer == LightType.BLOCK) {
            if (this.blockEngine == null) {
                return IWorldLightListener.Dummy.INSTANCE;
            }
            return this.blockEngine;
        }
        if (this.skyEngine == null) {
            return IWorldLightListener.Dummy.INSTANCE;
        }
        return this.skyEngine;
    }

    public int func_227470_b_(BlockPos blockPos, int i) {
        int j = this.skyEngine == null ? 0 : this.skyEngine.func_215611_b(blockPos) - i;
        int k = this.blockEngine == null ? 0 : this.blockEngine.func_215611_b(blockPos);
        return Math.max(k, j);
    }

    public void lightChunk(IChunk chunkAccess, boolean needLightBlockUpdate) {
        ChunkPos chunkPos = chunkAccess.func_76632_l();
        chunkAccess.func_217305_b(false);
        ChunkSection[] levelChunkSections = chunkAccess.func_76587_i();
        for (int i = 0; i < 16; ++i) {
            ChunkSection levelChunkSection = levelChunkSections[i];
            if (ChunkSection.func_222628_a((ChunkSection)levelChunkSection)) continue;
            this.func_215566_a(SectionPos.func_218156_a((ChunkPos)chunkPos, (int)i), false);
        }
        this.func_215571_a(chunkPos, true);
        if (needLightBlockUpdate) {
            chunkAccess.func_217304_m().forEach(blockPos -> this.func_215573_a((BlockPos)blockPos, chunkAccess.func_217298_h(blockPos)));
        }
        chunkAccess.func_217305_b(true);
    }

    public String func_215572_a(LightType lightLayer, SectionPos sectionPos) {
        throw new UnsupportedOperationException("This should never be used!");
    }

    public void func_215574_a(LightType lightLayer, SectionPos sectionPos, @Nullable NibbleArray dataLayer, boolean bl) {
        if (lightLayer == LightType.BLOCK) {
            if (this.blockEngine != null) {
                this.blockEngine.func_215621_a(sectionPos.func_218146_v(), dataLayer, bl);
            }
        } else if (this.skyEngine != null) {
            this.skyEngine.func_215621_a(sectionPos.func_218146_v(), dataLayer, bl);
        }
    }

    public void func_223115_b(ChunkPos chunkPos, boolean bl) {
        if (this.blockEngine != null) {
            this.blockEngine.func_223129_b(chunkPos, bl);
        }
        if (this.skyEngine != null) {
            this.skyEngine.func_223129_b(chunkPos, bl);
        }
    }
}

