/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import java.util.stream.Stream;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;

public class WorldGenStructFeatManager
extends StructureManager {
    final ISeedReader genLevel;
    DimensionGeneratorSettings worldGenSettings;

    public WorldGenStructFeatManager(DimensionGeneratorSettings worldGenSettings, ISeedReader genLevel) {
        super((IWorld)genLevel, worldGenSettings);
        this.genLevel = genLevel;
        this.worldGenSettings = worldGenSettings;
    }

    public WorldGenStructFeatManager forWorldGenRegion(WorldGenRegion worldGenRegion) {
        if (worldGenRegion == this.genLevel) {
            return this;
        }
        return new WorldGenStructFeatManager(this.worldGenSettings, (ISeedReader)worldGenRegion);
    }

    private IChunk _getChunk(int x, int z, ChunkStatus status) {
        if (this.genLevel == null) {
            return null;
        }
        return this.genLevel.func_217353_a(x, z, status, false);
    }

    public Stream<? extends StructureStart<?>> func_235011_a_(SectionPos sectionPos2, Structure<?> structureFeature) {
        IChunk chunk = this._getChunk(sectionPos2.func_218149_a(), sectionPos2.func_218148_c(), ChunkStatus.field_222607_c);
        if (chunk == null) {
            return Stream.empty();
        }
        return chunk.func_230346_b_(structureFeature).stream().map(pos -> {
            SectionPos sectPos = SectionPos.func_218154_a((int)ChunkPos.func_212578_a((long)pos), (int)0, (int)ChunkPos.func_212579_b((long)pos));
            IChunk startChunk = this._getChunk(sectPos.func_218149_a(), sectPos.func_218148_c(), ChunkStatus.field_222606_b);
            if (startChunk == null) {
                return null;
            }
            return this.func_235013_a_(sectPos, structureFeature, (IStructureReader)startChunk);
        }).filter(structureStart -> structureStart != null && structureStart.func_75069_d());
    }
}

