/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerTorchSlab {
    private static final HashMap<ResourceLocation, Block> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerTorchSlab.placeTorch(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeTorch(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        if (face == Direction.UP && world.func_180495_p(pos).func_177230_c() instanceof SlabBlock && world.func_180495_p(pos).func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM && (world.func_175623_d(placeAt) || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_207212_b)) {
            if (block instanceof IWaterLoggable) {
                world.func_175656_a(placeAt, (BlockState)block.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a)));
            } else {
                world.func_175656_a(placeAt, block.func_176223_P());
            }
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), block.func_220072_p(world.func_180495_p(pos)).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getPlayer().func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Block torchSlab) {
        if (!PLACE_ENTRIES.containsKey(itemName) && torchSlab != null) {
            PLACE_ENTRIES.put(itemName, torchSlab);
        }
    }

    public static Collection<Block> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

