/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsCategory;

public class BackpackSettingsHandler {
    public static final String SETTINGS_TAG = "settings";
    private final CompoundNBT backpackContentsNbt;
    private final Runnable markBackpackContentsDirty;
    private final Map<Class<?>, List<?>> interfaceCategories = new HashMap();
    private final Map<String, ISettingsCategory> settingsCategories = new LinkedHashMap<String, ISettingsCategory>();
    private final Map<Class<? extends ISettingsCategory>, ISettingsCategory> typeCategories = new HashMap<Class<? extends ISettingsCategory>, ISettingsCategory>();

    public BackpackSettingsHandler(IBackpackWrapper backpackWrapper, CompoundNBT backpackContentsNbt, Runnable markBackpackContentsDirty) {
        this.backpackContentsNbt = backpackContentsNbt;
        this.markBackpackContentsDirty = markBackpackContentsDirty;
        this.addSettingsCategories(backpackWrapper, backpackContentsNbt.func_74775_l(SETTINGS_TAG));
    }

    private void addSettingsCategories(IBackpackWrapper backpackWrapper, CompoundNBT settingsNbt) {
        this.addSettingsCategory(settingsNbt, "backpack", this.markBackpackContentsDirty, BackpackSettingsCategory::new);
        this.addSettingsCategory(settingsNbt, "no_sort", this.markBackpackContentsDirty, NoSortSettingsCategory::new);
        this.addSettingsCategory(settingsNbt, "memory", this.markBackpackContentsDirty, (categoryNbt, saveNbt) -> new MemorySettingsCategory(backpackWrapper, (CompoundNBT)categoryNbt, (Consumer<CompoundNBT>)saveNbt));
        this.addSettingsCategory(settingsNbt, "item_display", this.markBackpackContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(backpackWrapper, (CompoundNBT)categoryNbt, (Consumer<CompoundNBT>)saveNbt));
    }

    private void addSettingsCategory(CompoundNBT settingsNbt, String categoryName, Runnable markBackpackContentsDirty, BiFunction<CompoundNBT, Consumer<CompoundNBT>, ISettingsCategory> instantiateCategory) {
        ISettingsCategory category = instantiateCategory.apply(settingsNbt.func_74775_l(categoryName), tag -> {
            settingsNbt.func_218657_a(categoryName, (INBT)tag);
            this.backpackContentsNbt.func_218657_a(SETTINGS_TAG, (INBT)settingsNbt);
            markBackpackContentsDirty.run();
        });
        this.settingsCategories.put(categoryName, category);
        this.typeCategories.put(category.getClass(), category);
    }

    public Map<String, ISettingsCategory> getSettingsCategories() {
        return this.settingsCategories;
    }

    public <T> List<T> getCategoriesThatImplement(Class<T> categoryClass) {
        return this.interfaceCategories.computeIfAbsent(categoryClass, this::getListOfWrappersThatImplement);
    }

    public <T extends ISettingsCategory> T getTypeCategory(Class<T> categoryClazz) {
        return (T)this.typeCategories.get(categoryClazz);
    }

    private <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<ISettingsCategory> ret = new ArrayList<ISettingsCategory>();
        for (ISettingsCategory category : this.settingsCategories.values()) {
            if (!uc.isInstance(category)) continue;
            ret.add(category);
        }
        return ret;
    }

    public void copyTo(BackpackSettingsHandler settingsHandler) {
        if (this.backpackContentsNbt.func_74764_b(SETTINGS_TAG)) {
            settingsHandler.backpackContentsNbt.func_218657_a(SETTINGS_TAG, this.backpackContentsNbt.func_74781_a(SETTINGS_TAG));
        }
    }

    public CompoundNBT getNbt() {
        return this.backpackContentsNbt.func_74775_l(SETTINGS_TAG);
    }

    public void reloadFrom(CompoundNBT backpackContentsNbt) {
        CompoundNBT settingsNbt = backpackContentsNbt.func_74775_l(SETTINGS_TAG);
        this.settingsCategories.forEach((categoryName, category) -> category.reloadFrom(settingsNbt.func_74775_l(categoryName)));
    }
}

