/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.BackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeBackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;

public abstract class Tab
extends CompositeBackpackWidget<BackpackWidget> {
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    public static final int DEFAULT_HEIGHT = 24;
    protected static final int DEFAULT_WIDTH = 21;
    private int width = 21;
    private int height = 24;
    private final List<ITextProperties> tooltip;
    private BooleanSupplier shouldShowTooltip = () -> true;
    private BooleanSupplier shouldRender = () -> true;

    protected Tab(Position position, List<ITextProperties> tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        super(position);
        this.tooltip = tooltip;
        this.addChild(getTabButton.apply(this::onTabIconClicked));
    }

    protected Tab(Position position, ITextComponent tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        this(position, (List<ITextProperties>)ImmutableList.of((Object)tooltip), getTabButton);
    }

    public void setHandlers(BooleanSupplier shouldShowTooltip, BooleanSupplier shouldRender) {
        this.shouldShowTooltip = shouldShowTooltip;
        this.shouldRender = shouldRender;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRender.getAsBoolean()) {
            return;
        }
        if (this.isClosedTooltipVisible(mouseX, mouseY)) {
            GuiHelper.setTooltipToRender(this.tooltip);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Rectangle2d getRectangle() {
        return new Rectangle2d(this.x, this.y, this.width, this.height);
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(GuiHelper.GUI_CONTROLS);
        int halfHeight = this.height / 2;
        Tab.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (float)(256.0f - (float)this.width), (float)0.0f, (int)this.width, (int)halfHeight, (int)256, (int)256);
        Tab.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)(this.y + halfHeight), (float)(256.0f - (float)this.width), (float)(256.0f - (float)halfHeight), (int)this.width, (int)halfHeight, (int)256, (int)256);
        this.func_238474_b_(matrixStack, this.x - 3, this.y, 128, 256 - this.height, 3, this.height);
    }

    protected boolean isClosedTooltipVisible(int mouseX, int mouseY) {
        return this.shouldShowTooltip.getAsBoolean() && this.func_231047_b_(mouseX, mouseY);
    }

    public int getTopY() {
        return this.y;
    }

    public int getBottomY() {
        return this.y + this.getHeight();
    }

    protected abstract void onTabIconClicked(int var1);
}

