/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;

public class BackpackDynamicModel
implements IModelGeometry<BackpackDynamicModel> {
    private final Map<ModelPart, IUnbakedModel> modelParts;

    public BackpackDynamicModel(Map<ModelPart, IUnbakedModel> modelParts) {
        this.modelParts = modelParts;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelParts.forEach((part, model) -> {
            IBakedModel bakedModel = model.func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation);
            if (bakedModel != null) {
                builder.put((Object)part, (Object)bakedModel);
            }
        });
        return new BakedModel((Map<ModelPart, IBakedModel>)builder.build(), modelTransform);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.modelParts.forEach((part, model) -> builder.addAll((Iterable)model.func_225614_a_(modelGetter, missingTextureErrors)));
        return builder.build();
    }

    private static enum ModelPart {
        BASE,
        BATTERY,
        FRONT_POUCH,
        LEFT_POUCH,
        LEFT_TANK,
        RIGHT_POUCH,
        RIGHT_TANK;

    }

    public static final class Loader
    implements IModelLoader<BackpackDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public BackpackDynamicModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation clipsTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder texturesBuilder = ImmutableMap.builder();
            if (modelContents.has("clipsTexture") && (clipsTexture = ResourceLocation.func_208304_a((String)modelContents.get("clipsTexture").getAsString())) != null) {
                texturesBuilder.put((Object)"clips", (Object)Either.left((Object)new RenderMaterial(PlayerContainer.field_226615_c_, clipsTexture)));
            }
            ImmutableMap textures = texturesBuilder.build();
            for (ModelPart part : ModelPart.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelPart, IUnbakedModel>)builder, part, (ImmutableMap<String, Either<RenderMaterial, String>>)textures);
            }
            return new BackpackDynamicModel((Map<ModelPart, IUnbakedModel>)builder.build());
        }

        private void addPartModel(ImmutableMap.Builder<ModelPart, IUnbakedModel> builder, ModelPart modelPart, ImmutableMap<String, Either<RenderMaterial, String>> textures) {
            builder.put((Object)modelPart, (Object)new BlockModel(RegistryHelper.getRL("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH)), Collections.emptyList(), textures, true, null, ItemCameraTransforms.field_178357_a, Collections.emptyList()));
        }
    }

    private static class BackpackItemOverrideList
    extends ItemOverrideList {
        private final BakedModel backpackModel;

        public BackpackItemOverrideList(BakedModel backpackModel) {
            this.backpackModel = backpackModel;
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
            this.backpackModel.tankRight = false;
            this.backpackModel.tankLeft = false;
            this.backpackModel.battery = false;
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
                BackpackRenderInfo renderInfo = backpackWrapper.getRenderInfo();
                Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = renderInfo.getTankRenderInfos();
                tankRenderInfos.forEach((pos, info) -> {
                    if (pos == TankPosition.LEFT) {
                        this.backpackModel.tankLeft = true;
                        this.backpackModel.leftTankRenderInfo = info;
                    } else {
                        this.backpackModel.tankRight = true;
                        this.backpackModel.rightTankRenderInfo = info;
                    }
                });
                renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                    this.backpackModel.battery = true;
                    this.backpackModel.batteryRenderInfo = batteryRenderInfo;
                });
            });
            return this.backpackModel;
        }
    }

    private static final class BakedModel
    implements IDynamicBakedModel {
        private static final Map<ItemCameraTransforms.TransformType, TransformationMatrix> TRANSFORMS;
        private static final ResourceLocation BACKPACK_MODULES_TEXTURE;
        private final BackpackItemOverrideList overrideList = new BackpackItemOverrideList(this);
        private final Map<ModelPart, IBakedModel> models;
        private final IModelTransform modelTransform;
        private boolean tankLeft;
        @Nullable
        private IRenderedTankUpgrade.TankRenderInfo leftTankRenderInfo = null;
        private boolean tankRight;
        @Nullable
        private IRenderedTankUpgrade.TankRenderInfo rightTankRenderInfo = null;
        private boolean battery;
        @Nullable
        private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;

        public BakedModel(Map<ModelPart, IBakedModel> models, IModelTransform modelTransform) {
            this.models = models;
            this.modelTransform = modelTransform;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(this.models.get((Object)ModelPart.BASE).getQuads(state, side, rand, extraData));
            if (state == null) {
                this.addLeftSide(state, side, rand, extraData, ret, this.tankLeft);
                this.addRightSide(state, side, rand, extraData, ret, this.tankRight);
                this.addFront(state, side, rand, extraData, ret, this.battery);
            } else {
                this.addLeftSide(state, side, rand, extraData, ret, (Boolean)state.func_177229_b((Property)BackpackBlock.LEFT_TANK));
                this.addRightSide(state, side, rand, extraData, ret, (Boolean)state.func_177229_b((Property)BackpackBlock.RIGHT_TANK));
                this.addFront(state, side, rand, extraData, ret, (Boolean)state.func_177229_b((Property)BackpackBlock.BATTERY));
            }
            return ret;
        }

        private void addFront(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData, List<BakedQuad> ret, boolean battery) {
            if (battery) {
                if (this.batteryRenderInfo != null) {
                    this.addCharge(ret, this.batteryRenderInfo.getChargeRatio());
                }
                ret.addAll(this.models.get((Object)ModelPart.BATTERY).getQuads(state, side, rand, extraData));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.FRONT_POUCH).getQuads(state, side, rand, extraData));
            }
        }

        private void addCharge(List<BakedQuad> ret, float chargeRatio) {
            if (MathHelper.func_180185_a((float)chargeRatio, (float)0.0f)) {
                return;
            }
            int pixels = (int)(chargeRatio * 4.0f);
            float minX = (float)(10 - pixels) / 16.0f;
            float minY = 0.125f;
            float minZ = 0.121875f;
            float maxX = minX + (float)pixels / 16.0f;
            float maxY = minY + 0.0625f;
            float[] cols = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(BACKPACK_MODULES_TEXTURE);
            ret.add(this.createQuad((List<Vector3f>)ImmutableList.of((Object)this.getVector(maxX, maxY, minZ), (Object)this.getVector(maxX, minY, minZ), (Object)this.getVector(minX, minY, minZ), (Object)this.getVector(minX, maxY, minZ)), cols, sprite, Direction.NORTH, 14.0f, 14.0f + (float)pixels / 2.0f, 6.0f, 6.5f));
        }

        private void addRightSide(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData, List<BakedQuad> ret, boolean tankRight) {
            if (tankRight) {
                if (this.rightTankRenderInfo != null) {
                    this.rightTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(ret, (Fluid)fluid, this.rightTankRenderInfo.getFillRatio(), 0.0375));
                }
                ret.addAll(this.models.get((Object)ModelPart.RIGHT_TANK).getQuads(state, side, rand, extraData));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.RIGHT_POUCH).getQuads(state, side, rand, extraData));
            }
        }

        private void addLeftSide(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData, List<BakedQuad> ret, boolean tankLeft) {
            if (tankLeft) {
                if (this.leftTankRenderInfo != null) {
                    this.leftTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(ret, (Fluid)fluid, this.leftTankRenderInfo.getFillRatio(), 0.803125));
                }
                ret.addAll(this.models.get((Object)ModelPart.LEFT_TANK).getQuads(state, side, rand, extraData));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.LEFT_POUCH).getQuads(state, side, rand, extraData));
            }
        }

        private void addFluid(List<BakedQuad> ret, Fluid fluid, float ratio, double xMin) {
            if (MathHelper.func_180185_a((float)ratio, (float)0.0f)) {
                return;
            }
            double yMin = 0.09375;
            double yMax = yMin + (double)(ratio * 6.0f) / 16.0;
            AxisAlignedBB bounds = new AxisAlignedBB(xMin, yMin, 0.421875, xMin + 0.15625, yMax, 0.578125);
            ResourceLocation texture = fluid.getAttributes().getStillTexture();
            int color = fluid.getAttributes().getColor();
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(texture);
            float bx1 = 0.0f;
            float bx2 = 5.0f;
            float by1 = 0.0f;
            float by2 = ratio * 10.0f;
            float bz1 = 0.0f;
            float bz2 = 5.0f;
            ret.add(this.createQuad((List<Vector3f>)ImmutableList.of((Object)this.getVector(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c), (Object)this.getVector(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f), (Object)this.getVector(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f), (Object)this.getVector(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c)), cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            ret.add(this.createQuad((List<Vector3f>)ImmutableList.of((Object)this.getVector(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c), (Object)this.getVector(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c), (Object)this.getVector(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c), (Object)this.getVector(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c)), cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            ret.add(this.createQuad((List<Vector3f>)ImmutableList.of((Object)this.getVector(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f), (Object)this.getVector(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f), (Object)this.getVector(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f), (Object)this.getVector(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f)), cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            ret.add(this.createQuad((List<Vector3f>)ImmutableList.of((Object)this.getVector(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c), (Object)this.getVector(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c), (Object)this.getVector(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f), (Object)this.getVector(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f)), cols, still, Direction.WEST, bz1, bz2, by1, by2));
            ret.add(this.createQuad((List<Vector3f>)ImmutableList.of((Object)this.getVector(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f), (Object)this.getVector(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f), (Object)this.getVector(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c), (Object)this.getVector(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c)), cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelTransform.func_225615_b_().func_227988_c_());
            return ret;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_230044_c_() {
            return true;
        }

        public boolean func_188618_c() {
            return true;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.models.get((Object)ModelPart.BASE).func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return this.overrideList;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack matrixStack) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.NONE) {
                return this;
            }
            TransformationMatrix tr = TRANSFORMS.get(cameraTransformType);
            if (!tr.isIdentity()) {
                tr.push(matrixStack);
            }
            return this;
        }

        private BakedQuad createQuad(List<Vector3f> vecs, float[] colors, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
            BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
            Vector3i dirVec = face.func_176730_m();
            Vector3f normal = new Vector3f((float)dirVec.func_177958_n(), (float)dirVec.func_177956_o(), (float)dirVec.func_177952_p());
            this.putVertex(builder, normal, vecs.get(0).func_195899_a(), vecs.get(0).func_195900_b(), vecs.get(0).func_195902_c(), u1, v1, sprite, colors);
            this.putVertex(builder, normal, vecs.get(1).func_195899_a(), vecs.get(1).func_195900_b(), vecs.get(1).func_195902_c(), u1, v2, sprite, colors);
            this.putVertex(builder, normal, vecs.get(2).func_195899_a(), vecs.get(2).func_195900_b(), vecs.get(2).func_195902_c(), u2, v2, sprite, colors);
            this.putVertex(builder, normal, vecs.get(3).func_195899_a(), vecs.get(3).func_195900_b(), vecs.get(3).func_195902_c(), u2, v1, sprite, colors);
            builder.setQuadOrientation(face);
            return builder.build();
        }

        private void putVertex(BakedQuadBuilder builder, Vector3f normal, float x, float y, float z, float u, float v, TextureAtlasSprite sprite, float[] col) {
            ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
            block6: for (int e = 0; e < elements.size(); ++e) {
                switch (((VertexFormatElement)elements.get(e)).func_177375_c()) {
                    case POSITION: {
                        builder.put(e, new float[]{x, y, z});
                        continue block6;
                    }
                    case COLOR: {
                        builder.put(e, new float[]{col[1], col[2], col[3], col[0]});
                        continue block6;
                    }
                    case UV: {
                        if (((VertexFormatElement)elements.get(e)).func_177369_e() == 0) {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(e, new float[]{iu, iv});
                            continue block6;
                        }
                        builder.put(e, new float[0]);
                        continue block6;
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        private void rotate(Vector3f posIn, Matrix4f transformIn) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = new Vector4f(posIn.func_195899_a() - originIn.func_195899_a(), posIn.func_195900_b() - originIn.func_195900_b(), posIn.func_195902_c() - originIn.func_195902_c(), 1.0f);
            vector4f.func_229372_a_(transformIn);
            posIn.func_195905_a(vector4f.func_195910_a() + originIn.func_195899_a(), vector4f.func_195913_b() + originIn.func_195900_b(), vector4f.func_195914_c() + originIn.func_195902_c());
        }

        static {
            BACKPACK_MODULES_TEXTURE = new ResourceLocation("sophisticatedbackpacks:block/backpack_modules");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, -0.125f, -0.28125f), new Quaternion(85.0f, -90.0f, 0.0f, true), new Vector3f(0.75f, 0.75f, 0.75f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, -0.125f, -0.28125f), new Quaternion(85.0f, -90.0f, 0.0f, true), new Vector3f(0.75f, 0.75f, 0.75f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.890625f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.078125f, 0.0f), new Quaternion(30.0f, 225.0f, 0.0f, true), new Vector3f(0.9f, 0.9f, 0.9f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.1875f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.0f, -0.140625f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.75f, 0.75f, 0.75f), null));
            TRANSFORMS = builder.build();
        }
    }
}

