/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackUUIDArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;

public class GiveCommand {
    private GiveCommand() {
    }

    static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"give").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"backpackUuid", (ArgumentType)BackpackUUIDArgumentType.backpackUuid()).executes(context -> GiveCommand.giveBackpack((CommandSource)context.getSource(), (UUID)context.getArgument("backpackUuid", UUID.class), EntityArgument.func_197090_e((CommandContext)context, (String)"targets")))));
    }

    private static int giveBackpack(CommandSource source, UUID backpackUuid, Collection<ServerPlayerEntity> players) {
        BackpackAccessLogger.getBackpackLog(backpackUuid).ifPresent(alr -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(alr.getBackpackItemRegistryName());
            ItemStack backpack = new ItemStack((IItemProvider)item);
            if (!backpack.func_200301_q().getString().equals(alr.getBackpackName())) {
                backpack.func_200302_a((ITextComponent)new StringTextComponent(alr.getBackpackName()));
            }
            backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
                backpackWrapper.setColors(alr.getClothColor(), alr.getTrimColor());
                backpackWrapper.setColumnsTaken(alr.getColumnsTaken());
                backpackWrapper.setContentsUuid(backpackUuid);
            });
            players.forEach(p -> GiveCommand.giveBackpackToPlayer(backpack, p));
            if (players.size() == 1) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.sophisticatedbackpacks.give.success", new Object[]{((ServerPlayerEntity)players.iterator().next()).func_145748_c_()}), true);
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.sophisticatedbackpacks.give.success", new Object[]{players.size()}), true);
            }
        });
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayerEntity p) {
        ItemEntity itemEntity;
        boolean flag = p.field_71071_by.func_70441_a(backpack);
        if (flag && backpack.func_190926_b()) {
            backpack.func_190920_e(1);
            itemEntity = p.func_71019_a(backpack, false);
            if (itemEntity != null) {
                itemEntity.func_174870_v();
            }
            p.field_70170_p.func_184148_a(null, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne(p.func_70681_au()) * 0.7f + 1.0f) * 2.0f);
            p.field_71069_bz.func_75142_b();
        } else {
            ItemEntity itementity = p.func_71019_a(backpack, false);
            if (itementity != null) {
                itementity.func_174868_q();
                itementity.func_200217_b(p.func_110124_au());
            }
        }
        itemEntity = p.func_71019_a(backpack, false);
        if (itemEntity != null) {
            itemEntity.func_174870_v();
        }
    }
}

