/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTileEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncClientInfoMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public abstract class BackpackContext {
    public abstract Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity var1);

    public abstract boolean shouldLockBackpackSlot(PlayerEntity var1);

    public abstract IBackpackWrapper getBackpackWrapper(PlayerEntity var1);

    public abstract int getBackpackSlotIndex();

    public abstract BackpackContext getSubBackpackContext(int var1);

    public abstract BackpackContext getParentBackpackContext();

    public abstract ContextType getType();

    public void toBuffer(PacketBuffer packetBuffer) {
        this.getType().toBuffer(packetBuffer);
        this.addToBuffer(packetBuffer);
    }

    public abstract void addToBuffer(PacketBuffer var1);

    public abstract boolean canInteractWith(PlayerEntity var1);

    public BlockPos getBackpackPosition(PlayerEntity playerEntity) {
        return playerEntity.func_233580_cy_();
    }

    public ITextComponent getDisplayName(PlayerEntity player) {
        return this.getBackpackWrapper(player).getBackpack().func_200301_q();
    }

    public abstract void onUpgradeChanged(PlayerEntity var1);

    public static BackpackContext fromBuffer(PacketBuffer buffer) {
        ContextType type = ContextType.fromBuffer(buffer);
        switch (type) {
            case BLOCK_BACKPACK: {
                return Block.fromBuffer(buffer);
            }
            case BLOCK_SUB_BACKPACK: {
                return BlockSubBackpack.fromBuffer(buffer);
            }
            case ITEM_SUB_BACKPACK: {
                return ItemSubBackpack.fromBuffer(buffer);
            }
        }
        return Item.fromBuffer(buffer);
    }

    public boolean wasOpenFromInventory() {
        return false;
    }

    public static class BlockSubBackpack
    extends Block {
        private final int subBackpackSlotIndex;
        @Nullable
        private IBackpackWrapper parentWrapper;

        public BlockSubBackpack(BlockPos pos, int subBackpackSlotIndex) {
            super(pos);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)NoopBackpackWrapper.INSTANCE)).orElse(NoopBackpackWrapper.INSTANCE);
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new BlockSubBackpack(BlockPos.func_218283_e((long)packetBuffer.readLong()), packetBuffer.readInt());
        }

        @Override
        public void addToBuffer(PacketBuffer packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Block(this.pos);
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_SUB_BACKPACK;
        }

        @Override
        public ITextComponent getDisplayName(PlayerEntity player) {
            return new StringTextComponent("... > " + super.getDisplayName(player).getString());
        }

        @Override
        public void onUpgradeChanged(PlayerEntity player) {
        }
    }

    public static class Block
    extends BackpackContext {
        protected final BlockPos pos;

        public Block(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getBackpackPosition(PlayerEntity playerEntity) {
            return this.pos;
        }

        @Override
        public void onUpgradeChanged(PlayerEntity player) {
            if (!player.field_70170_p.field_72995_K) {
                WorldHelper.getTile((IBlockReader)player.field_70170_p, this.pos, BackpackTileEntity.class).ifPresent(BackpackTileEntity::refreshRenderState);
            }
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(PlayerEntity player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return WorldHelper.getTile((IBlockReader)player.field_70170_p, this.pos, BackpackTileEntity.class).map(BackpackTileEntity::getBackpackWrapper).orElse(NoopBackpackWrapper.INSTANCE);
        }

        @Override
        public int getBackpackSlotIndex() {
            return -1;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new BlockSubBackpack(this.pos, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new Block(BlockPos.func_218283_e((long)packetBuffer.readLong()));
        }

        @Override
        public void addToBuffer(PacketBuffer packetBuffer) {
            packetBuffer.writeLong(this.pos.func_218275_a());
        }

        @Override
        public boolean canInteractWith(PlayerEntity player) {
            return player.field_70170_p.func_175625_s(this.pos) instanceof BackpackTileEntity && player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_BACKPACK;
        }
    }

    public static class ItemSubBackpack
    extends Item {
        private final int subBackpackSlotIndex;
        @Nullable
        private IBackpackWrapper parentWrapper;

        public ItemSubBackpack(String handlerName, String identifier, int backpackSlotIndex, boolean parentOpenFromInventory, int subBackpackSlotIndex) {
            super(handlerName, identifier, backpackSlotIndex, parentOpenFromInventory);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)NoopBackpackWrapper.INSTANCE)).orElse(NoopBackpackWrapper.INSTANCE);
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new ItemSubBackpack(packetBuffer.func_218666_n(), packetBuffer.func_218666_n(), packetBuffer.readInt(), packetBuffer.readBoolean(), packetBuffer.readInt());
        }

        @Override
        public void addToBuffer(PacketBuffer packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Item(this.handlerName, this.identifier, this.backpackSlotIndex, super.wasOpenFromInventory());
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_SUB_BACKPACK;
        }

        @Override
        public ITextComponent getDisplayName(PlayerEntity player) {
            return new StringTextComponent("... > " + super.getDisplayName(player).getString());
        }

        @Override
        public void onUpgradeChanged(PlayerEntity player) {
        }
    }

    public static class Item
    extends BackpackContext {
        protected final String handlerName;
        protected String identifier;
        protected final int backpackSlotIndex;
        private final boolean openFromInventory;

        public Item(String handlerName, int backpackSlotIndex) {
            this(handlerName, "", backpackSlotIndex);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex) {
            this(handlerName, identifier, backpackSlotIndex, false);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex, boolean openFromInventory) {
            this.handlerName = handlerName;
            this.identifier = identifier;
            this.backpackSlotIndex = backpackSlotIndex;
            this.openFromInventory = openFromInventory;
        }

        @Override
        public boolean wasOpenFromInventory() {
            return this.openFromInventory;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(PlayerEntity player) {
            return SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().getPlayerInventoryHandler(this.handlerName).map(PlayerInventoryHandler::isVisibleInGui).orElse(false);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            Optional<PlayerInventoryHandler> inventoryHandler = SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().getPlayerInventoryHandler(this.handlerName);
            if (!inventoryHandler.isPresent()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find inventory handler for \"{}\"", (Object)this.handlerName);
                return NoopBackpackWrapper.INSTANCE;
            }
            LazyOptional backpackWrapper = inventoryHandler.get().getStackInSlot(player, this.identifier, this.backpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance());
            if (!backpackWrapper.isPresent()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find backpack at slot index {} in \"{}\" inventory handler", (Object)this.backpackSlotIndex, (Object)this.handlerName);
                return NoopBackpackWrapper.INSTANCE;
            }
            return (IBackpackWrapper)backpackWrapper.orElse((Object)NoopBackpackWrapper.INSTANCE);
        }

        @Override
        public void onUpgradeChanged(PlayerEntity player) {
            if (!player.field_70170_p.field_72995_K && this.handlerName.equals("main")) {
                IBackpackWrapper backpackWrapper = this.getBackpackWrapper(player);
                PacketHandler.sendToClient((ServerPlayerEntity)player, new SyncClientInfoMessage(this.backpackSlotIndex, backpackWrapper.getRenderInfo().getNbt(), backpackWrapper.getColumnsTaken()));
            }
        }

        @Override
        public int getBackpackSlotIndex() {
            return this.backpackSlotIndex;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new ItemSubBackpack(this.handlerName, this.identifier, this.backpackSlotIndex, this.openFromInventory, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_BACKPACK;
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new Item(packetBuffer.func_218666_n(), packetBuffer.func_218666_n(), packetBuffer.readInt(), packetBuffer.readBoolean());
        }

        @Override
        public void addToBuffer(PacketBuffer packetBuffer) {
            packetBuffer.func_180714_a(this.handlerName);
            packetBuffer.func_180714_a(this.identifier);
            packetBuffer.writeInt(this.backpackSlotIndex);
            packetBuffer.writeBoolean(this.openFromInventory);
        }

        @Override
        public boolean canInteractWith(PlayerEntity player) {
            return true;
        }
    }

    public static enum ContextType {
        BLOCK_BACKPACK(0, false),
        BLOCK_SUB_BACKPACK(1, true),
        ITEM_BACKPACK(2, false),
        ITEM_SUB_BACKPACK(3, true);

        private final int id;
        private final boolean isSubBackpack;
        private static final Map<Integer, ContextType> ID_CONTEXTS;

        private ContextType(int id, boolean isSubBackpack) {
            this.id = id;
            this.isSubBackpack = isSubBackpack;
        }

        public void toBuffer(PacketBuffer buffer) {
            buffer.writeShort(this.id);
        }

        public boolean isSubBackpack() {
            return this.isSubBackpack;
        }

        public static ContextType fromBuffer(PacketBuffer buffer) {
            return ID_CONTEXTS.getOrDefault(buffer.readShort(), ITEM_BACKPACK);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (ContextType value : ContextType.values()) {
                builder.put((Object)value.id, (Object)value);
            }
            ID_CONTEXTS = builder.build();
        }
    }
}

