/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;

public class UpgradeContainerRegistry {
    private static final Map<ResourceLocation, UpgradeContainerType<? extends IUpgradeWrapper, ? extends UpgradeContainerBase<?, ?>>> UPGRADE_CONTAINERS = new HashMap();

    private UpgradeContainerRegistry() {
    }

    public static void register(ResourceLocation upgradeName, UpgradeContainerType<? extends IUpgradeWrapper, ? extends UpgradeContainerBase<?, ?>> containerFactory) {
        UPGRADE_CONTAINERS.put(upgradeName, containerFactory);
    }

    public static <W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>> Optional<UpgradeContainerBase<W, C>> instantiateContainer(PlayerEntity player, int containerId, W wrapper) {
        ResourceLocation upgradeName = wrapper.getUpgradeStack().func_77973_b().getRegistryName();
        if (!(wrapper.getUpgradeStack().func_77973_b() instanceof IBackpackUpgradeItem) || wrapper.hideSettingsTab() || !UPGRADE_CONTAINERS.containsKey(upgradeName)) {
            return Optional.empty();
        }
        return Optional.of(UpgradeContainerRegistry.getContainerType(upgradeName).create(player, containerId, wrapper));
    }

    private static <W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>> UpgradeContainerType<W, C> getContainerType(ResourceLocation upgradeName) {
        return UPGRADE_CONTAINERS.get(upgradeName);
    }
}

