/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;

public abstract class SettingsContainerBase<C extends ISettingsCategory> {
    private final SettingsContainer settingsContainer;
    private final String categoryName;
    private final C category;

    protected SettingsContainerBase(SettingsContainer settingsContainer, String categoryName, C category) {
        this.settingsContainer = settingsContainer;
        this.categoryName = categoryName;
        this.category = category;
    }

    protected C getCategory() {
        return this.category;
    }

    protected SettingsContainer getSettingsContainer() {
        return this.settingsContainer;
    }

    public void sendIntToServer(String key, int value) {
        this.sendDataToServer(() -> {
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a(key, value);
            return data;
        });
    }

    public void sendStringToServer(String key, String value) {
        this.sendDataToServer(() -> {
            CompoundNBT data = new CompoundNBT();
            data.func_74778_a(key, value);
            return data;
        });
    }

    public void sendDataToServer(Supplier<CompoundNBT> supplyData) {
        if (this.isServer()) {
            return;
        }
        CompoundNBT data = supplyData.get();
        data.func_74778_a("categoryName", this.categoryName);
        PacketHandler.sendToServer(new SyncContainerClientDataMessage(data));
    }

    protected boolean isServer() {
        return !this.settingsContainer.getPlayer().field_70170_p.field_72995_K;
    }

    public abstract void handleMessage(CompoundNBT var1);
}

