/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), backpackWrapper::getInventoryHandler, backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public ItemStack pickup(World world, ItemStack stack, boolean simulate) {
        if (!this.shouldPickupItems() || !this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        return this.backpackWrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        int cooldown;
        if (this.isInCooldown(world)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, world, pos) : 40;
        if (this.shouldPickupXp() && this.canFillBackpackWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, world, pos));
        }
        this.setCooldown(world, cooldown);
    }

    private boolean canFillBackpackWithXp() {
        return this.backpackWrapper.getFluidHandler().map(fluidHandler -> fluidHandler.fill((ITag<Fluid>)ModFluids.EXPERIENCE_TAG, 1, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
    }

    private int pickupXpOrbs(@Nullable LivingEntity entity, World world, BlockPos pos) {
        List xpEntities = world.func_175647_a(ExperienceOrbEntity.class, new AxisAlignedBB(pos).func_186662_g((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        for (ExperienceOrbEntity xpOrb : xpEntities) {
            if (!xpOrb.func_70089_S() || this.canNotPickup((Entity)xpOrb, entity) || this.tryToFillTank(xpOrb, entity, world)) continue;
            cooldown = 40;
            break;
        }
        return cooldown;
    }

    private boolean tryToFillTank(ExperienceOrbEntity xpOrb, @Nullable LivingEntity entity, World world) {
        int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.func_70526_d());
        return this.backpackWrapper.getFluidHandler().map(fluidHandler -> {
            int amountAdded = fluidHandler.fill((ITag<Fluid>)ModFluids.EXPERIENCE_TAG, amountToTransfer, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE);
            if (amountAdded > 0) {
                Vector3d pos = xpOrb.func_213303_ch();
                xpOrb.field_70530_e = 0;
                xpOrb.func_70106_y();
                PlayerEntity player = (PlayerEntity)entity;
                if (player != null) {
                    MagnetUpgradeWrapper.playXpPickupSound(world, player);
                }
                if (amountToTransfer > amountAdded) {
                    world.func_217376_c((Entity)new ExperienceOrbEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), (int)XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable LivingEntity entity, World world, BlockPos pos) {
        List itemEntities = world.func_217394_a(EntityType.field_200765_E, new AxisAlignedBB(pos).func_186662_g((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        PlayerEntity player = (PlayerEntity)entity;
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.func_70089_S() || !this.filterLogic.matchesFilter(itemEntity.func_92059_d()) || this.canNotPickup((Entity)itemEntity, entity)) continue;
            if (this.tryToInsertItem(itemEntity)) {
                if (player == null) continue;
                MagnetUpgradeWrapper.playItemPickupSound(world, player);
                continue;
            }
            cooldown = 40;
        }
        return cooldown;
    }

    private static void playItemPickupSound(World world, @Nonnull PlayerEntity player) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 1.4f + 2.0f);
    }

    private static void playXpPickupSound(World world, @Nonnull PlayerEntity player) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.35f + 0.9f);
    }

    private boolean isBlockedBySomething(Entity entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(Entity entity, @Nullable LivingEntity player) {
        if (this.isBlockedBySomething(entity)) {
            return true;
        }
        CompoundNBT data = entity.getPersistentData();
        return player != null ? data.func_74764_b(PREVENT_REMOTE_MOVEMENT) : data.func_74764_b(PREVENT_REMOTE_MOVEMENT) && !data.func_74764_b(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        ItemStack remaining = inventory.insertItem(stack, true);
        boolean insertedSomething = false;
        if (remaining.func_190916_E() != stack.func_190916_E()) {
            insertedSomething = true;
            remaining = inventory.insertItem(stack, false);
            itemEntity.func_92058_a(remaining);
        }
        return insertedSomething;
    }

    public void setPickupItems(boolean pickupItems) {
        NBTHelper.setBoolean(this.upgrade, "pickupItems", pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return NBTHelper.getBoolean(this.upgrade, "pickupItems").orElse(true);
    }

    public void setPickupXp(boolean pickupXp) {
        NBTHelper.setBoolean(this.upgrade, "pickupXp", pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return NBTHelper.getBoolean(this.upgrade, "pickupXp").orElse(true);
    }
}

