/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FluidFilterLogic {
    private final List<Fluid> fluidFilters;
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private boolean noFilter = true;

    public FluidFilterLogic(int filterSlots, ItemStack upgrade, Consumer<ItemStack> saveHandler) {
        this.fluidFilters = NonNullList.func_191197_a((int)filterSlots, (Object)Fluids.field_204541_a);
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.deserializeFluidFilters();
        this.updateNoFilter();
    }

    private void deserializeFluidFilters() {
        NBTHelper.getTagValue(this.upgrade, "", "fluids", (c, n1) -> c.func_150295_c(n1, 8)).ifPresent(listNbt -> {
            int i = 0;
            for (INBT elementNbt : listNbt) {
                Fluid value = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(elementNbt.func_150285_a_()));
                if (value != null) {
                    this.fluidFilters.set(i, value);
                }
                if (++i < this.fluidFilters.size()) continue;
                break;
            }
        });
    }

    private void updateNoFilter() {
        this.noFilter = true;
        for (Fluid fluidFilter : this.fluidFilters) {
            if (fluidFilter == Fluids.field_204541_a) continue;
            this.noFilter = false;
            return;
        }
    }

    public boolean fluidMatches(Fluid fluid) {
        return this.noFilter || this.matchesFluidFilter(fluid);
    }

    private boolean matchesFluidFilter(Fluid fluid) {
        for (Fluid fluidFilter : this.fluidFilters) {
            if (fluidFilter != fluid) continue;
            return true;
        }
        return false;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public void setFluid(int index, Fluid fluid) {
        this.fluidFilters.set(index, fluid);
        this.serializeFluidFilters();
        this.updateNoFilter();
        this.save();
    }

    public Fluid getFluid(int index) {
        return this.fluidFilters.get(index);
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilters.size();
    }

    private void serializeFluidFilters() {
        ListNBT fluids = new ListNBT();
        this.fluidFilters.forEach(f -> fluids.add((Object)StringNBT.func_229705_a_((String)f.getRegistryName().toString())));
        this.upgrade.func_196082_o().func_218657_a("fluids", (INBT)fluids);
    }
}

