/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class RefillUpgradeWrapper
extends UpgradeWrapperBase<RefillUpgradeWrapper, RefillUpgradeItem>
implements IFilteredUpgrade,
ITickableUpgrade {
    private static final int COOLDOWN = 5;
    private final FilterLogic filterLogic;

    public RefillUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)Config.COMMON.refillUpgrade.filterSlots.get());
        this.filterLogic.setAllowByDefault();
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (entity == null || this.isInCooldown(world)) {
            return;
        }
        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(playerInvHandler -> InventoryHelper.iterate((IItemHandler)this.filterLogic.getFilterHandler(), (slot, filter) -> {
            if (filter.func_190926_b()) {
                return;
            }
            int missingCount = InventoryHelper.getCountMissingInHandler(playerInvHandler, filter, filter.func_77976_d());
            if (missingCount == 0) {
                return;
            }
            IItemHandlerSimpleInserter extractFromHandler = this.backpackWrapper.getInventoryForUpgradeProcessing();
            ItemStack toMove = filter.func_77946_l();
            toMove.func_190920_e(missingCount);
            ItemStack extracted = InventoryHelper.extractFromInventory(toMove, (IItemHandler)extractFromHandler, true);
            if (extracted.func_190926_b()) {
                return;
            }
            if (missingCount < filter.func_77976_d()) {
                this.refillExistingStack((IItemHandler)playerInvHandler, (IItemHandler)extractFromHandler, extracted);
            } else {
                this.refillAnywhereInInventory((IItemHandler)playerInvHandler, (IItemHandler)extractFromHandler, toMove, extracted);
            }
        }));
        this.setCooldown(world, 5);
    }

    private void refillExistingStack(IItemHandler playerInvHandler, IItemHandler extractFromHandler, ItemStack extracted) {
        AtomicBoolean refilledStack = new AtomicBoolean(false);
        InventoryHelper.iterate(playerInvHandler, (slot, stack) -> {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)extracted)) {
                playerInvHandler.insertItem(slot.intValue(), InventoryHelper.extractFromInventory(extracted, extractFromHandler, false), false);
                refilledStack.set(true);
            }
        }, refilledStack::get);
    }

    private void refillAnywhereInInventory(IItemHandler playerInvHandler, IItemHandler extractFromHandler, ItemStack toMove, ItemStack extracted) {
        ItemStack remaining = InventoryHelper.insertIntoInventory(extracted, playerInvHandler, true);
        if (remaining.func_190916_E() == extracted.func_190916_E()) {
            return;
        }
        toMove.func_190920_e(extracted.func_190916_E() - remaining.func_190916_E());
        InventoryHelper.insertIntoInventory(InventoryHelper.extractFromInventory(toMove, extractFromHandler, false), playerInvHandler, false);
    }
}

