/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeWrapper;

public class TankUpgradeContainer
extends UpgradeContainerBase<TankUpgradeWrapper, TankUpgradeContainer> {
    public static final ResourceLocation EMPTY_TANK_INPUT_SLOT_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "item/empty_tank_input_slot");
    public static final ResourceLocation EMPTY_TANK_OUTPUT_SLOT_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "item/empty_tank_output_slot");

    public TankUpgradeContainer(PlayerEntity player, int upgradeContainerId, TankUpgradeWrapper upgradeWrapper, UpgradeContainerType<TankUpgradeWrapper, TankUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        this.slots.add(new TankIOSlot(() -> ((TankUpgradeWrapper)this.upgradeWrapper).getInventory(), 0, -100, -100, TranslationHelper.translUpgradeSlotTooltip("tank_input")).setBackground(PlayerContainer.field_226615_c_, EMPTY_TANK_INPUT_SLOT_BACKGROUND));
        this.slots.add(new TankIOSlot(() -> ((TankUpgradeWrapper)this.upgradeWrapper).getInventory(), 1, -100, -100, TranslationHelper.translUpgradeSlotTooltip("tank_output")).setBackground(PlayerContainer.field_226615_c_, EMPTY_TANK_OUTPUT_SLOT_BACKGROUND));
    }

    @Override
    public void handleMessage(CompoundNBT data) {
    }

    public FluidStack getContents() {
        return ((TankUpgradeWrapper)this.upgradeWrapper).getContents();
    }

    public int getTankCapacity() {
        return ((TankUpgradeWrapper)this.upgradeWrapper).getTankCapacity();
    }

    private static class TankIOSlot
    extends SlotSuppliedHandler
    implements INameableEmptySlot {
        private final ITextComponent emptyTooltip;

        public TankIOSlot(Supplier<IItemHandler> itemHandlerSupplier, int slot, int xPosition, int yPosition, ITextComponent emptyTooltip) {
            super(itemHandlerSupplier, slot, xPosition, yPosition);
            this.emptyTooltip = emptyTooltip;
        }

        @Override
        public boolean hasEmptyTooltip() {
            return true;
        }

        @Override
        public ITextComponent getEmptyTooltip() {
            return this.emptyTooltip;
        }
    }
}

