/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class PlayerInventoryHandler {
    public static final Set<String> SINGLE_IDENTIFIER = Collections.singleton("");
    private final Function<Long, Set<String>> identifiersGetter;
    private final SlotCountGetter slotCountGetter;
    private final SlotStackGetter slotStackGetter;
    private final boolean visibleInGui;
    private final boolean ownRenderer;

    public PlayerInventoryHandler(Function<Long, Set<String>> identifiersGetter, SlotCountGetter slotCountGetter, SlotStackGetter slotStackGetter, boolean visibleInGui, boolean ownRenderer) {
        this.identifiersGetter = identifiersGetter;
        this.slotCountGetter = slotCountGetter;
        this.slotStackGetter = slotStackGetter;
        this.visibleInGui = visibleInGui;
        this.ownRenderer = ownRenderer;
    }

    public int getSlotCount(PlayerEntity player, String identifier) {
        return this.slotCountGetter.getSlotCount(player, identifier);
    }

    public ItemStack getStackInSlot(PlayerEntity player, String identifier, int slot) {
        return this.slotStackGetter.getStackInSlot(player, identifier, slot);
    }

    public boolean isVisibleInGui() {
        return this.visibleInGui;
    }

    public Set<String> getIdentifiers(long gameTime) {
        return this.identifiersGetter.apply(gameTime);
    }

    public boolean hasItsOwnRenderer() {
        return this.ownRenderer;
    }

    public static interface SlotStackGetter {
        public ItemStack getStackInSlot(PlayerEntity var1, String var2, int var3);
    }

    public static interface SlotCountGetter {
        public int getSlotCount(PlayerEntity var1, String var2);
    }

    public static interface IStackInSlotModifier {
        public void accept(PlayerEntity var1, int var2, ItemStack var3);
    }
}

