/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.comforts.Comforts;

public class ComfortsBaseBlock
extends BedBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final Field SLEEP_TIMER = ObfuscationReflectionHelper.findField(PlayerEntity.class, (String)"field_71076_b");
    private final BedType type;

    public ComfortsBaseBlock(BedType type, DyeColor colorIn, AbstractBlock.Properties properties) {
        super(colorIn, properties);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((Property)field_176471_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b((Property)field_176472_a) != BedPart.HEAD && !(state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!ComfortsBaseBlock.func_235330_a_((World)worldIn)) {
            worldIn.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d());
            if (worldIn.func_180495_p(blockpos).func_203425_a((Block)this)) {
                worldIn.func_217377_a(blockpos, false);
            }
            worldIn.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)field_176471_b)).booleanValue()) {
            if (!this.func_226861_a_(worldIn, pos)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.comforts." + this.type.name + ".occupied"), true);
            }
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity) {
            ComfortsBaseBlock.trySleep((ServerPlayerEntity)player, pos).ifLeft(result -> {
                if (result != null) {
                    ITextComponent text;
                    switch (result) {
                        case NOT_POSSIBLE_NOW: {
                            text = this.type == BedType.HAMMOCK ? new TranslationTextComponent("block.comforts." + this.type.name + ".no_sleep") : new TranslationTextComponent("block.minecraft.bed.no_sleep");
                            break;
                        }
                        case TOO_FAR_AWAY: {
                            text = new TranslationTextComponent("block.comforts." + this.type.name + ".too_far_away");
                            break;
                        }
                        default: {
                            text = result.func_221259_a();
                        }
                    }
                    player.func_146105_b(text, true);
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    public static Either<PlayerEntity.SleepResult, Unit> trySleep(ServerPlayerEntity playerEntity, BlockPos at) {
        Optional<BlockPos> optAt = Optional.of(at);
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)playerEntity, optAt);
        if (ret != null) {
            return Either.left((Object)ret);
        }
        Direction direction = (Direction)playerEntity.field_70170_p.func_180495_p(at).func_177229_b((Property)HorizontalBlock.field_185512_D);
        if (!playerEntity.func_70608_bn() && playerEntity.func_70089_S()) {
            if (!playerEntity.field_70170_p.func_230315_m_().func_236043_f_()) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
            }
            if (!ComfortsBaseBlock.func_241147_a_(playerEntity, at, direction)) {
                return Either.left((Object)PlayerEntity.SleepResult.TOO_FAR_AWAY);
            }
            if (ComfortsBaseBlock.func_241156_b_(playerEntity, at, direction)) {
                return Either.left((Object)PlayerEntity.SleepResult.OBSTRUCTED);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)playerEntity, optAt)) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
            }
            if (!playerEntity.func_184812_l_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)at);
                List list = playerEntity.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB(vector3d.func_82615_a() - 8.0, vector3d.func_82617_b() - 5.0, vector3d.func_82616_c() - 8.0, vector3d.func_82615_a() + 8.0, vector3d.func_82617_b() + 5.0, vector3d.func_82616_c() + 8.0), p_241146_1_ -> p_241146_1_.func_230292_f_((PlayerEntity)playerEntity));
                if (!list.isEmpty()) {
                    return Either.left((Object)PlayerEntity.SleepResult.NOT_SAFE);
                }
            }
            playerEntity.func_213342_e(at);
            try {
                SLEEP_TIMER.setInt(playerEntity, 0);
            }
            catch (IllegalAccessException e) {
                Comforts.LOGGER.error("Error setting sleep timer!");
            }
            playerEntity.func_195066_a(Stats.field_188064_ad);
            CriteriaTriggers.field_192136_p.func_192215_a(playerEntity);
            ((ServerWorld)playerEntity.field_70170_p).func_72854_c();
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
    }

    private static boolean func_241147_a_(ServerPlayerEntity playerEntity, BlockPos p_241147_1_, Direction p_241147_2_) {
        if (p_241147_2_ == null) {
            return false;
        }
        return ComfortsBaseBlock.func_241158_g_(playerEntity, p_241147_1_) || ComfortsBaseBlock.func_241158_g_(playerEntity, p_241147_1_.func_177972_a(p_241147_2_.func_176734_d()));
    }

    private static boolean func_241158_g_(ServerPlayerEntity playerEntity, BlockPos p_241158_1_) {
        Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)p_241158_1_);
        return Math.abs(playerEntity.func_226277_ct_() - vector3d.func_82615_a()) <= 3.0 && Math.abs(playerEntity.func_226278_cu_() - vector3d.func_82617_b()) <= 2.0 && Math.abs(playerEntity.func_226281_cx_() - vector3d.func_82616_c()) <= 3.0;
    }

    private static boolean func_241156_b_(ServerPlayerEntity playerEntity, BlockPos p_241156_1_, Direction p_241156_2_) {
        BlockPos blockpos = p_241156_1_.func_177984_a();
        return ComfortsBaseBlock.isAbnormalCube(playerEntity.field_70170_p, blockpos) || ComfortsBaseBlock.isAbnormalCube(playerEntity.field_70170_p, blockpos.func_177972_a(p_241156_2_.func_176734_d()));
    }

    private static boolean isAbnormalCube(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_229980_m_((IBlockReader)world, pos);
    }

    private boolean func_226861_a_(World p_226861_1_, BlockPos p_226861_2_) {
        List list = p_226861_1_.func_175647_a(VillagerEntity.class, new AxisAlignedBB(p_226861_2_), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        ((VillagerEntity)list.get(0)).func_213366_dy();
        return true;
    }

    public void func_176208_a(World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!worldIn.field_72995_K && player.func_184812_l_() && (bedpart = (BedPart)state.func_177229_b((Property)field_176472_a)) == BedPart.FOOT && (blockstate = worldIn.func_180495_p(blockpos = pos.func_177972_a(ComfortsBaseBlock.getDirectionToOther(bedpart, (Direction)state.func_177229_b((Property)field_185512_D))))).func_177230_c() == this && blockstate.func_177229_b((Property)field_176472_a) == BedPart.HEAD) {
            if (((Boolean)blockstate.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                worldIn.func_180501_a(blockpos, Blocks.field_150355_j.func_176223_P(), 35);
            } else {
                worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            }
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        worldIn.func_217378_a(player, 2001, pos, ComfortsBaseBlock.func_196246_j((BlockState)state));
        if (this.func_203417_a((ITag)BlockTags.field_232883_ay_)) {
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)false);
        }
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState state = super.func_196258_a(context);
        return state == null ? null : (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
        super.func_206840_a(builder);
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

