/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.recipe.TagIngredient;
import shadows.placebo.util.RunnableReloader;

public class RecipeHelper {
    private static final List<IRecipe<?>> recipes = new ArrayList();
    protected String modid;
    protected Set<String> names = new HashSet<String>();

    public RecipeHelper(String modid) {
        this.modid = modid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecipe(IRecipe<?> rec) {
        List<IRecipe<?>> list = recipes;
        synchronized (list) {
            if (rec == null) {
                Placebo.LOGGER.error("Attempted to add null recipe, this is invalid behavior.");
                Thread.dumpStack();
            }
            recipes.add(rec);
        }
    }

    public void addShapeless(Object output, Object ... inputs) {
        ItemStack out = RecipeHelper.makeStack(output);
        RecipeHelper.addRecipe(new ShapelessRecipe(this.name(out), this.modid, out, this.createInput(false, inputs)));
    }

    public void addShaped(Object output, int width, int height, Object ... input) {
        RecipeHelper.addRecipe(this.genShaped(RecipeHelper.makeStack(output), width, height, input));
    }

    public ShapedRecipe genShaped(ItemStack output, int l, int w, Object ... input) {
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modid);
        }
        return new ShapedRecipe(this.name(output), this.modid, l, w, this.createInput(true, input), output);
    }

    public NonNullList<Ingredient> createInput(boolean allowEmpty, Object ... input) {
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new TagIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)CachedIngredient.create((ItemStack)k));
                continue;
            }
            if (k instanceof IForgeRegistryEntry) {
                inputL.add(i, (Object)CachedIngredient.create(RecipeHelper.makeStack(k)));
                continue;
            }
            if (k instanceof Ingredient) {
                inputL.add(i, (Object)((Ingredient)k));
                continue;
            }
            if (allowEmpty) {
                inputL.add(i, (Object)Ingredient.field_193370_a);
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid recipe.  Complain to the author of " + this.modid + ". (Input " + k + " not allowed.)");
        }
        return inputL;
    }

    public void addSimpleShapeless(Object output, Object input, int numInputs) {
        this.addShapeless(output, NonNullList.func_191197_a((int)numInputs, (Object)RecipeHelper.makeStack(input)).toArray(new Object[0]));
    }

    private ResourceLocation name(ItemStack out) {
        String name = out.func_77973_b().getRegistryName().func_110623_a();
        while (this.names.contains(name)) {
            name = name + "_";
        }
        this.names.add(name);
        return new ResourceLocation(this.modid, name);
    }

    public static ItemStack makeStack(Object thing, int size) {
        if (thing instanceof ItemStack) {
            return (ItemStack)thing;
        }
        if (thing instanceof Item) {
            return new ItemStack((IItemProvider)((Item)thing), size);
        }
        if (thing instanceof Block) {
            return new ItemStack((IItemProvider)((Block)thing), size);
        }
        throw new IllegalArgumentException("Attempted to create an ItemStack from something that cannot be converted: " + thing);
    }

    public static ItemStack makeStack(Object thing) {
        return RecipeHelper.makeStack(thing, 1);
    }

    static void addRecipes(RecipeManager mgr) {
        recipes.forEach(r -> {
            Map map = mgr.field_199522_d.computeIfAbsent(r.func_222127_g(), t -> new HashMap());
            IRecipe old = (IRecipe)map.get(r.func_199560_c());
            if (old == null) {
                r.func_192400_c().stream().filter(i -> i instanceof TagIngredient).map(i -> (TagIngredient)((Object)((Object)i))).forEach(TagIngredient::redefine);
                map.put(r.func_199560_c(), r);
            }
        });
        Placebo.LOGGER.info("Registered {} additional recipes.", (Object)recipes.size());
    }

    public static void mutableManager(RecipeManager mgr) {
        mgr.field_199522_d = new HashMap(mgr.field_199522_d);
        for (IRecipeType type : mgr.field_199522_d.keySet()) {
            mgr.field_199522_d.put(type, new HashMap((Map)mgr.field_199522_d.get(type)));
        }
    }

    public static void reload(RecipeManager mgr, IReloadableResourceManager rel) {
        rel.func_219534_a((IFutureReloadListener)RunnableReloader.of(() -> {
            RecipeHelper.mutableManager(mgr);
            RecipeHelper.addRecipes(mgr);
        }));
    }

    public static class CachedIngredient
    extends Ingredient {
        private static Int2ObjectMap<CachedIngredient> ingredients = new Int2ObjectOpenHashMap();

        private CachedIngredient(ItemStack ... matches) {
            super(Arrays.stream(matches).map(Ingredient.SingleItemList::new));
            if (matches.length == 1) {
                ingredients.put(RecipeItemHelper.func_194113_b((ItemStack)matches[0]), (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CachedIngredient create(ItemStack ... matches) {
            Int2ObjectMap<CachedIngredient> int2ObjectMap = ingredients;
            synchronized (int2ObjectMap) {
                if (matches.length == 1) {
                    CachedIngredient coi = (CachedIngredient)((Object)ingredients.get(RecipeItemHelper.func_194113_b((ItemStack)matches[0])));
                    CachedIngredient cachedIngredient = coi != null ? coi : new CachedIngredient(matches);
                    return cachedIngredient;
                }
                return new CachedIngredient(matches);
            }
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return VanillaIngredientSerializer.INSTANCE;
        }
    }
}

