/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.command;

import com.connectivity.command.IMCCommand;
import com.connectivity.command.IMCOPCommand;
import com.connectivity.networkstats.NetworkStatGatherer;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;

public class CommandNetworkStatsTotal
implements IMCOPCommand {
    public static final String NETWORKSTATS_SUMMARY_COMMAND = "/connectivity packetsSummary %d %d";

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        NetworkStatGatherer.reportStatsSummary(source, 5, 0);
        return 0;
    }

    @Override
    public String getName() {
        return "packetsSummary";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("minutes", IntegerArgumentType.integer((int)1, (int)400)).executes(this::executeWithMinutes)).then(IMCCommand.newArgument("index", IntegerArgumentType.integer((int)0, (int)400)).executes(this::executeWithMinutesandIndex)))).executes(this::checkPreConditionAndExecute);
    }

    private int executeWithMinutes(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        NetworkStatGatherer.reportStatsSummary(source, IntegerArgumentType.getInteger(context, (String)"minutes"), 0);
        return 0;
    }

    private int executeWithMinutesandIndex(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        NetworkStatGatherer.reportStatsSummary(source, IntegerArgumentType.getInteger(context, (String)"minutes"), IntegerArgumentType.getInteger(context, (String)"index"));
        return 0;
    }
}

