/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.networkstats;

import com.connectivity.Connectivity;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class NetworkStatGatherer {
    private static volatile Map<String, ConcurrentHashMap<String, PacketData>> connectionPacketData = new ConcurrentHashMap<String, ConcurrentHashMap<String, PacketData>>();
    private static final int recordingDuration = (Integer)Connectivity.config.getCommonConfig().packetHistoryMinutes.get();
    private static List<Map<String, ConcurrentHashMap<String, PacketData>>> minuteData = new ArrayList<Map<String, ConcurrentHashMap<String, PacketData>>>(recordingDuration);
    static int index = 0;

    public static void add(String remoteAddress, String packetName, int packetSize) {
        connectionPacketData.computeIfAbsent(remoteAddress, remote -> new ConcurrentHashMap()).computeIfAbsent(packetName, name -> new PacketData((String)name)).add(packetSize);
    }

    public static void saveData() {
        if (++index >= recordingDuration) {
            index = 0;
        }
        minuteData.set(index, connectionPacketData);
        connectionPacketData = new ConcurrentHashMap<String, ConcurrentHashMap<String, PacketData>>();
    }

    public static PlayerPacketDataEntry getDataForPlayer(ServerPlayerEntity playerEntity, int minutes) {
        String id = playerEntity.field_71135_a.field_147371_a.channel().remoteAddress().toString();
        HashMap<String, PacketData> gatherMap = new HashMap<String, PacketData>();
        int timeMinutes = minutes;
        for (int i = 0; i < minutes; ++i) {
            int preIndex = Math.abs((index - i) % recordingDuration);
            Map<String, ConcurrentHashMap<String, PacketData>> data2 = minuteData.get(preIndex);
            if (data2 != null && data2.containsKey(id)) {
                NetworkStatGatherer.condenseDataToMap(data2.get(id).values(), gatherMap);
            }
            if (data2 != null) continue;
            --timeMinutes;
        }
        ArrayList<PacketData> dataList = new ArrayList<PacketData>(gatherMap.values());
        dataList.sort(Comparator.comparingLong(data -> data.totalPacketBytes).reversed());
        NetworkStatGatherer.calculateThroughput(dataList, timeMinutes);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData entry : dataList) {
            totalBytes += entry.totalPacketBytes;
            totalRate += entry.rate;
        }
        return new PlayerPacketDataEntry(dataList, totalBytes, totalRate, playerEntity);
    }

    public static List<PacketData> getDataByPacket(int minutes) {
        HashMap<String, PacketData> gatherMap = new HashMap<String, PacketData>();
        int timeMinutes = minutes;
        for (int i = 0; i < minutes; ++i) {
            int preIndex = Math.abs((index - i) % recordingDuration);
            Map<String, ConcurrentHashMap<String, PacketData>> data2 = minuteData.get(preIndex);
            if (data2 != null) {
                for (Map.Entry<String, ConcurrentHashMap<String, PacketData>> entry : data2.entrySet()) {
                    NetworkStatGatherer.condenseDataToMap(entry.getValue().values(), gatherMap);
                }
                continue;
            }
            --timeMinutes;
        }
        ArrayList<PacketData> result = new ArrayList<PacketData>(gatherMap.values());
        result.sort(Comparator.comparingLong(data -> data.totalPacketBytes).reversed());
        NetworkStatGatherer.calculateThroughput(result, timeMinutes);
        return result;
    }

    private static void calculateThroughput(Collection<PacketData> data, int minutes) {
        if (minutes <= 0) {
            return;
        }
        for (PacketData packetData : data) {
            packetData.rate = (double)((float)packetData.totalPacketBytes / ((float)minutes * 60.0f)) / 1000.0;
        }
    }

    private static void condenseDataToMap(Collection<PacketData> insertData, Map<String, PacketData> dataMap) {
        if (insertData == null) {
            return;
        }
        for (PacketData data : insertData) {
            if (dataMap.containsKey(data.packetName)) {
                PacketData existing = dataMap.get(data.packetName);
                existing.totalPacketBytes += data.totalPacketBytes;
                existing.packetCount += data.packetCount;
                existing.maxPacketBytes = Math.max(existing.maxPacketBytes, data.maxPacketBytes);
                continue;
            }
            PacketData newData = new PacketData(data.packetName);
            newData.totalPacketBytes = data.totalPacketBytes;
            newData.maxPacketBytes = data.maxPacketBytes;
            newData.packetCount = data.packetCount;
            dataMap.put(data.packetName, newData);
        }
    }

    public static void reportAllPlayerSummary(CommandSource source, int minutes, int startIndex) {
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
        Style BLUE = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
        Style RED = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED));
        ArrayList<PlayerPacketDataEntry> playerData = new ArrayList<PlayerPacketDataEntry>();
        for (ServerPlayerEntity player : source.func_197023_e().func_73046_m().func_184103_al().func_181057_v()) {
            playerData.add(NetworkStatGatherer.getDataForPlayer(player, minutes));
        }
        playerData.sort(Comparator.comparingLong(data -> data.totalBytes).reversed());
        source.func_197030_a((ITextComponent)new StringTextComponent("Network players summary of last " + minutes + " minutes."), false);
        long byteSum = 0L;
        for (PlayerPacketDataEntry packetData : playerData) {
            byteSum += packetData.totalBytes;
        }
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < playerData.size(); ++i) {
            PlayerPacketDataEntry playerPacketDataEntry = (PlayerPacketDataEntry)playerData.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent(percent.format((double)playerPacketDataEntry.totalBytes / (double)byteSum * 100.0) + "% ").func_230529_a_((ITextComponent)new StringTextComponent(playerPacketDataEntry.playerEntity.func_200200_C_().getString() + " ")).func_230530_a_(GREEN_BOLD).func_230529_a_((ITextComponent)new StringTextComponent("r: " + percent.format(playerPacketDataEntry.totalRate) + "kb/s ").func_230530_a_(BLUE)).func_230529_a_((ITextComponent)new StringTextComponent("total sent: " + percent.format((double)playerPacketDataEntry.totalBytes / 1000.0) + "kb").func_230530_a_(RED)), false);
        }
        if (i + 1 < playerData.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next --->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsAllPlayers %d %d", minutes, i)))), false);
        }
    }

    public static void reportStatsSummary(CommandSource source, int minutes, int startIndex) {
        List<PacketData> data = NetworkStatGatherer.getDataByPacket(minutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
        Style BLUE = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
        Style YELLOW = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW));
        Style RED = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED));
        Style GOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GOLD));
        source.func_197030_a((ITextComponent)new StringTextComponent("Network packet summary of last " + minutes + " minutes."), false);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate)).func_230530_a_(GOLD), false);
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ").func_230529_a_((ITextComponent)new StringTextComponent(packetData.packetName + " ")).func_230530_a_(GREEN_BOLD).func_230529_a_((ITextComponent)new StringTextComponent("r: " + percent.format(packetData.rate) + "kb/s ").func_230530_a_(BLUE)).func_230529_a_((ITextComponent)new StringTextComponent("count:" + packetData.packetCount + " ").func_230530_a_(YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb").func_230530_a_(RED)), false);
        }
        if (i + 1 < data.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next --->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsSummary %d %d", minutes, i)))), false);
        }
    }

    public static void reportPlayerSummary(CommandSource source, ServerPlayerEntity playerEntity, int minutes, int startIndex) {
        if (playerEntity == null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Player not found"), true);
            return;
        }
        PlayerPacketDataEntry playerPacketData = NetworkStatGatherer.getDataForPlayer(playerEntity, minutes);
        List<PacketData> data = playerPacketData.packetData;
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
        Style BLUE = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
        Style YELLOW = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW));
        Style RED = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED));
        Style GOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GOLD));
        source.func_197030_a((ITextComponent)new StringTextComponent("Network packet summary for " + playerEntity.func_200200_C_().getString() + " of last " + minutes + " minutes."), false);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate)).func_230530_a_(GOLD), false);
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ").func_230529_a_((ITextComponent)new StringTextComponent(packetData.packetName + " ")).func_230530_a_(GREEN_BOLD).func_230529_a_((ITextComponent)new StringTextComponent("r: " + percent.format(packetData.rate) + "kb/s ").func_230530_a_(BLUE)).func_230529_a_((ITextComponent)new StringTextComponent("count:" + packetData.packetCount + " ").func_230530_a_(YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb").func_230530_a_(RED)), false);
        }
        if (i + 1 < data.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next --->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsPlayer %s %d %d", playerEntity.func_200200_C_().getString(), minutes, i)))), false);
        }
    }

    public static void reportClientStatsSummary(PlayerEntity playerEntity, int minutes, int startIndex) {
        if (playerEntity == null) {
            return;
        }
        List<PacketData> data = NetworkStatGatherer.getDataByPacket(minutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
        Style BLUE = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
        Style YELLOW = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW));
        Style RED = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED));
        Style GOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GOLD));
        playerEntity.func_145747_a((ITextComponent)new StringTextComponent("Network outgoing packet summary of last " + minutes + " minutes."), playerEntity.func_110124_au());
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        playerEntity.func_145747_a((ITextComponent)new StringTextComponent("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate)).func_230530_a_(GOLD), playerEntity.func_110124_au());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            playerEntity.func_145747_a((ITextComponent)new StringTextComponent(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ").func_230529_a_((ITextComponent)new StringTextComponent(packetData.packetName + " ")).func_230530_a_(GREEN_BOLD).func_230529_a_((ITextComponent)new StringTextComponent("r: " + percent.format(packetData.rate) + "kb/s ").func_230530_a_(BLUE)).func_230529_a_((ITextComponent)new StringTextComponent("count:" + packetData.packetCount + " ").func_230530_a_(YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb").func_230530_a_(RED)), playerEntity.func_110124_au());
        }
        if (i + 1 < data.size()) {
            playerEntity.func_145747_a((ITextComponent)new StringTextComponent("next --->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsClient %d %d", minutes, i)))), playerEntity.func_110124_au());
        }
    }

    static {
        for (int i = 0; i < recordingDuration; ++i) {
            minuteData.add(null);
        }
    }

    private static class PlayerPacketDataEntry {
        final List<PacketData> packetData;
        final long totalBytes;
        final double totalRate;
        final ServerPlayerEntity playerEntity;

        private PlayerPacketDataEntry(List<PacketData> packetData, long totalBytes, double totalRate, ServerPlayerEntity playerEntity) {
            this.packetData = packetData;
            this.totalBytes = totalBytes;
            this.totalRate = totalRate;
            this.playerEntity = playerEntity;
        }
    }

    private static class PacketData {
        public final String packetName;
        public int maxPacketBytes = 0;
        public long totalPacketBytes = 0L;
        public int packetCount = 0;
        public double rate = 0.0;

        private PacketData(String packetName) {
            this.packetName = packetName;
        }

        void add(int packetSize) {
            if (this.maxPacketBytes < packetSize) {
                this.maxPacketBytes = packetSize;
            }
            ++this.packetCount;
            this.totalPacketBytes += (long)packetSize;
        }
    }
}

