/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import javax.annotation.Nullable;
import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import me.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TileEntity.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Shadow
    protected BlockPos field_174879_c;
    @Shadow
    @Nullable
    protected World field_145850_b;
    @Shadow
    protected boolean field_145846_f;
    private int lambdynlights_luminance = 0;
    private int lambdynlights_lastLuminance = 0;
    private long lambdynlights_lastUpdate = 0L;
    private LongOpenHashSet trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double getDynamicLightX() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    @Override
    public double getDynamicLightY() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    @Override
    public double getDynamicLightZ() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    @Override
    public World getDynamicLightWorld() {
        return this.field_145850_b;
    }

    @Inject(method={"setRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.setDynamicLightEnabled(false);
    }

    @Override
    public void resetDynamicLight() {
        this.lambdynlights_lastLuminance = 0;
    }

    @Override
    public void dynamicLightTick() {
        if (this.field_145850_b == null || !this.field_145850_b.func_201670_d()) {
            return;
        }
        if (!this.field_145846_f) {
            this.lambdynlights_luminance = DynamicLightHandlers.getLuminanceFrom((TileEntity)this);
            DynamicLightsReforged.updateTracking(this);
            if (!this.isDynamicLightEnabled()) {
                this.lambdynlights_lastLuminance = 0;
            }
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights_luminance;
    }

    @Override
    public boolean shouldUpdateDynamicLight() {
        return DynamicLightsReforged.ShouldUpdateDynamicLights();
    }

    @Override
    public boolean lambdynlights_updateDynamicLight(@NotNull WorldRenderer renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.getLuminance();
        if (luminance != this.lambdynlights_lastLuminance) {
            this.lambdynlights_lastLuminance = luminance;
            if (this.trackedLitChunkPos.isEmpty()) {
                BlockPos.Mutable chunkPos = new BlockPos.Mutable(MathHelper.func_76137_a((int)this.field_174879_c.func_177958_n(), (int)16), MathHelper.func_76137_a((int)this.field_174879_c.func_177956_o(), (int)16), MathHelper.func_76137_a((int)this.field_174879_c.func_177952_p(), (int)16));
                DynamicLightsReforged.updateTrackedChunks((BlockPos)chunkPos, null, this.trackedLitChunkPos);
                Direction directionX = (this.field_174879_c.func_177958_n() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (this.field_174879_c.func_177956_o() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.field_174879_c.func_177952_p() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.func_189536_c(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.func_189536_c(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.func_189536_c(directionX.func_176734_d());
                    } else {
                        chunkPos.func_189536_c(directionZ.func_176734_d());
                        chunkPos.func_189536_c(directionY);
                    }
                    DynamicLightsReforged.updateTrackedChunks((BlockPos)chunkPos, null, this.trackedLitChunkPos);
                }
            }
            this.lambdynlights_scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void lambdynlights_scheduleTrackedChunksRebuild(@NotNull WorldRenderer renderer) {
        if (this.field_145850_b == Minecraft.func_71410_x().field_71441_e) {
            LongIterator longIterator = this.trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                DynamicLightsReforged.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

