/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.config.json;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.aperlambda.lambdacommon.LambdaConstants;
import org.aperlambda.lambdacommon.config.FileConfig;
import org.aperlambda.lambdacommon.config.json.BaseJsonConfig;

public class JsonConfig
extends FileConfig<JsonObject>
implements BaseJsonConfig {
    private JsonObject config;

    public JsonConfig() {
    }

    public JsonConfig(File file) {
        super(file);
    }

    @Override
    public void load() {
        try {
            this.config = LambdaConstants.JSON_PARSER.parse(Files.asCharSource((File)this.file, (Charset)Charset.defaultCharset()).read()).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save() {
        if (!this.file.exists() && !this.file.getParentFile().mkdirs()) {
            throw new RuntimeException(new IOException("Cannot create the parent directory of the json configuration file."));
        }
        try {
            Files.asCharSink((File)this.file, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)LambdaConstants.GSON_PRETTY.toJson((JsonElement)this.config));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(String key, Object value) {
        if (key.contains(".")) {
            String[] path = key.split("\\.");
            JsonObject currentObject = this.config;
            for (int i = 0; i < path.length - 1; ++i) {
                String currentKey = path[i];
                if (!currentObject.has(currentKey)) {
                    currentObject.add(currentKey, (JsonElement)new JsonObject());
                }
                currentObject = currentObject.getAsJsonObject(currentKey);
            }
            currentObject.add(path[path.length - 1], LambdaConstants.GSON_PRETTY.toJsonTree(value));
        } else {
            this.config.add(key, LambdaConstants.GSON_PRETTY.toJsonTree(value));
        }
        if (this.autoSave) {
            this.save();
        }
    }

    @Override
    public <T> T at(String path, T def, Class<T> type) {
        return JsonConfig.jsonAt(this.config, path, def, type);
    }

    @Override
    public <T> T get(String key, T def, Class<T> type) {
        return JsonConfig.jsonGet(this.config, key, def, type);
    }

    static <T> T jsonGet(JsonObject config, String key, T def, Class<T> type) {
        Object value = LambdaConstants.GSON_PRETTY.fromJson(config.get(key), type);
        return (T)(value == null ? def : value);
    }

    static <T> T jsonAt(JsonObject config, String path, T def, Class<T> type) {
        if (path.contains(".")) {
            try {
                String[] parts = path.split("\\.");
                JsonObject currentElement = config;
                for (int i = 0; i < parts.length - 1; ++i) {
                    if ((currentElement = currentElement.getAsJsonObject().get(parts[i])) == null) {
                        return def;
                    }
                    if (currentElement.isJsonObject()) continue;
                    throw new IllegalArgumentException("Field '" + parts[i] + "' isn't an object!");
                }
                Object value = LambdaConstants.GSON_PRETTY.fromJson(currentElement.getAsJsonObject().get(parts[parts.length - 1]), type);
                return (T)(value == null ? def : value);
            }
            catch (JsonParseException e) {
                return def;
            }
        }
        return JsonConfig.jsonGet(config, path, def, type);
    }

    @Override
    public JsonObject getConfig() {
        return this.config;
    }
}

