/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.math;

import org.aperlambda.lambdacommon.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class Vec3i32
implements Comparable<Vec3i32> {
    public static final Vec3i32 ZERO = new Vec3i32(0, 0, 0);
    public final int x;
    public final int y;
    public final int z;

    public Vec3i32(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i32(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public double standard() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public int scalarProduct(Vec3i32 b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public Vec3i32 add(Vec3i32 other) {
        if (other == null) {
            other = ZERO;
        }
        return new Vec3i32(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vec3i32 subtract(Vec3i32 other) {
        if (other == null) {
            other = ZERO;
        }
        return new Vec3i32(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vec3i32 negate() {
        return new Vec3i32(-this.x, -this.y, -this.z);
    }

    public Vec3i32 multiply(int lambda) {
        return new Vec3i32(lambda * this.x, lambda * this.y, lambda * this.z);
    }

    @Override
    public int compareTo(@NotNull Vec3i32 vec3i32) {
        if (this.y == vec3i32.y) {
            return this.z == vec3i32.z ? this.x - vec3i32.x : this.z - vec3i32.z;
        }
        return this.y - vec3i32.y;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Vec3i32)) {
            return false;
        }
        Vec3i32 other = (Vec3i32)object;
        if (this.x != other.x) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        return this.y == other.y;
    }
}

