/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcesManager {
    private static final ResourcesManager DEFAULT_RESOURCES_MANAGER = new ResourcesManager();

    @NotNull
    public static ResourcesManager getDefaultResourcesManager() {
        return DEFAULT_RESOURCES_MANAGER;
    }

    public boolean saveResource(@NotNull URL path, @NotNull File dest, boolean replace) {
        if (path.getPath() == null) {
            return false;
        }
        InputStream is = this.getResource(path);
        if (is == null) {
            return false;
        }
        return this.saveResource(is, path.getPath(), dest, replace);
    }

    public boolean saveResource(@NotNull InputStream input, @NotNull String path, @NotNull File dest, boolean replace) {
        File outFile = new File(dest, path);
        File parentDir = outFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new RuntimeException(new IOException("Cannot create the parent directory of the resource to save."));
        }
        if (!outFile.exists() || replace) {
            try {
                Files.copy(input, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public boolean saveResourceFromJar(@NotNull String path, @NotNull File dest, boolean replace) {
        InputStream is = this.getResourceFromJar(path = path.replace('\\', '/'));
        if (is == null) {
            return false;
        }
        return this.saveResource(is, path, dest, replace);
    }

    @Nullable
    public InputStream getResource(@NotNull URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public InputStream getResourceFromJar(@NotNull String file) {
        Optional<URL> url = this.getResourceUrlFromJar(file);
        return url.map(this::getResource).orElse(null);
    }

    @NotNull
    public Optional<URL> getResourceUrlFromJar(@NotNull String file) {
        return Optional.ofNullable(this.getClass().getClassLoader().getResource(file));
    }
}

