/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.system;

import org.aperlambda.lambdacommon.utils.Nameable;
import org.jetbrains.annotations.NotNull;

public enum OS implements Nameable
{
    WINDOWS("Windows", "win"),
    OSX("OSX", "mac"),
    LINUX("Linux", "linux"),
    SOLARIS("Solaris", "solaris", "sunos"),
    FREEBSD("FreeBSD", new String[0]),
    OPENBSD("OpenBSD", new String[0]),
    NETBSD("NetBSD", new String[0]),
    UNKNOWN("Unknown", "unknown");

    private String prettyName;
    private String[] designations;

    private OS(String prettyName, String ... designations) {
        this.prettyName = prettyName;
        this.designations = designations;
    }

    public static OS getCurrentPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (OS os : OS.values()) {
            for (String oStr : os.designations) {
                if (!osName.contains(oStr)) continue;
                return os;
            }
        }
        return UNKNOWN;
    }

    @Override
    @NotNull
    public String getName() {
        return this.prettyName;
    }
}

