/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaReflection {
    private LambdaReflection() {
        throw new IllegalStateException("LambdaReflection is a full static class!");
    }

    private static void setupField(Field field) {
        field.setAccessible(true);
    }

    @NotNull
    public static Optional<Field> getField(@NotNull Class<?> clazz, @NotNull String fieldName, boolean declared) {
        try {
            Field field = declared ? clazz.getDeclaredField(fieldName) : clazz.getField(fieldName);
            LambdaReflection.setupField(field);
            return Optional.of(field);
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    @NotNull
    public static Optional<Field> getFirstFieldOfType(@NotNull Class<?> clazz, @NotNull Class<?> type) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(type)) continue;
            LambdaReflection.setupField(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<Field> getLastFieldOfType(@NotNull Class<?> clazz, @NotNull Class<?> type) {
        Field field = null;
        for (Field currentField : clazz.getDeclaredFields()) {
            if (!currentField.getType().equals(type)) continue;
            field = currentField;
        }
        if (field != null) {
            LambdaReflection.setupField(field);
        }
        return Optional.ofNullable(field);
    }

    public static void setValue(@Nullable Object object, @NotNull Field field, @Nullable Object value) {
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static Object getFieldValue(@Nullable Object object, @NotNull Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <V> V getFieldValue(@Nullable Object object, @NotNull Field field, V defaultValue) {
        field.setAccessible(true);
        try {
            return (V)field.get(object);
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static Optional<Method> getMethod(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... parameterTypes) {
        return LambdaReflection.getMethod(clazz, name, true, parameterTypes);
    }

    @NotNull
    public static Optional<Method> getMethod(@NotNull Class<?> clazz, @NotNull String name, boolean declared, Class<?> ... parameterTypes) {
        try {
            Optional<Method> method = Optional.of(declared ? clazz.getDeclaredMethod(name, parameterTypes) : clazz.getMethod(name, parameterTypes));
            method.ifPresent(m -> m.setAccessible(true));
            return method;
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static Object invokeMethod(@Nullable Object object, @NotNull Method method, Object ... arguments) {
        method.setAccessible(true);
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    @NotNull
    public static <T> Optional<Constructor<T>> getConstructor(@NotNull Class<T> clazz, Class<?> ... arguments) {
        return LambdaReflection.getConstructor(clazz, true, arguments);
    }

    @NotNull
    public static <T> Optional<Constructor<T>> getConstructor(@NotNull Class<T> clazz, boolean declared, Class<?> ... arguments) {
        try {
            return Optional.of(declared ? clazz.getDeclaredConstructor(arguments) : clazz.getConstructor(arguments));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static <T> T newInstance(@NotNull Constructor<T> constructor, Object ... arguments) {
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    @NotNull
    public static Optional<Class<?>> getClass(String name) {
        try {
            return Optional.ofNullable(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static boolean doesClassExist(String name) {
        return LambdaReflection.getClass(name).isPresent();
    }
}

