/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.BinaryType;
import codechicken.lib.render.shader.ConstantCache;
import codechicken.lib.render.shader.NamedShaderObject;
import codechicken.lib.render.shader.ShaderConstantCache;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.Uniform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL46;

public class BinaryShaderObject
extends NamedShaderObject
implements ISelectiveResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation asset;
    private final BinaryType binaryType;
    private final String entryPoint;
    private final ShaderConstantCache constantCache = new ShaderConstantCache();
    private final Consumer<ConstantCache> specializationCallback;
    private boolean dirty = false;
    private int shaderId = -1;

    public BinaryShaderObject(String name, ResourceLocation asset, ShaderObject.ShaderType type, BinaryType binaryType, String entryPoint, Collection<Uniform> uniforms, Consumer<ConstantCache> specializationCallback) {
        super(name, type, uniforms);
        this.asset = asset;
        this.binaryType = binaryType;
        this.entryPoint = entryPoint;
        this.specializationCallback = specializationCallback;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void alloc() {
        if (this.dirty || this.shaderId == -1) {
            if (this.shaderId == -1) {
                this.shaderId = GL20.glCreateShader((int)this.getShaderType().getGLCode());
                if (this.shaderId == 0) {
                    throw new IllegalStateException("Allocation of ShaderObject failed.");
                }
            }
            byte[] source = this.getRawSource();
            ByteBuffer sourceBuffer = BufferUtils.createByteBuffer((int)source.length).order(ByteOrder.nativeOrder());
            sourceBuffer.put(source);
            sourceBuffer.flip();
            GL46.glShaderBinary((int[])new int[]{this.shaderId}, (int)this.binaryType.getGLCode(), (ByteBuffer)sourceBuffer);
            this.specializationCallback.accept(this.constantCache);
            GL46.glSpecializeShader((int)this.shaderId, (CharSequence)this.entryPoint, (int[])this.constantCache.getIndices(), (int[])this.constantCache.getValues());
            if (GL20.glGetShaderi((int)this.shaderId, (int)35713) == 0) {
                throw new RuntimeException("ShaderProgram linkage failure. \n" + GL20.glGetShaderInfoLog((int)this.shaderId));
            }
            this.dirty = false;
        }
    }

    @Override
    public int getShaderID() {
        return this.shaderId;
    }

    @Override
    public void onLink(int programId) {
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.dirty = true;
    }

    /*
     * Exception decompiling
     */
    private byte[] getRawSource() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

