/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import net.minecraft.client.settings.GraphicsFanciness;

public class SodiumGameOptions {
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final ExperimentalSettings experimental = new ExperimentalSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    private Path configPath;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public void notifyListeners() {
        SodiumClientMod.onConfigChanged(this);
    }

    public static SodiumGameOptions load(Path path) {
        SodiumGameOptions config;
        block17: {
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SodiumGameOptions)GSON.fromJson((Reader)reader, SodiumGameOptions.class);
                    break block17;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new SodiumGameOptions();
        }
        config.configPath = path;
        try {
            config.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    public void writeChanges() throws IOException {
        Path dir = this.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        Files.write(this.configPath, GSON.toJson((Object)this).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static enum LightingQuality implements TextProvider
    {
        HIGH("High"),
        LOW("Low"),
        OFF("Off");

        private final String name;

        private LightingQuality(String name) {
            this.name = name;
        }

        @Override
        public String getLocalizedName() {
            return this.name;
        }
    }

    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT("Default"),
        FANCY("Fancy"),
        FAST("Fast");

        private final String name;

        private GraphicsQuality(String name) {
            this.name = name;
        }

        @Override
        public String getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(GraphicsFanciness graphicsMode) {
            return this == FANCY || this == DEFAULT && (graphicsMode == GraphicsFanciness.FANCY || graphicsMode == GraphicsFanciness.FABULOUS);
        }
    }

    public static class NotificationSettings {
        public boolean hideDonationButton = false;
    }

    public static class QualitySettings {
        public GraphicsQuality cloudQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality leavesQuality = GraphicsQuality.DEFAULT;
        public boolean enableVignette = true;
        public boolean enableClouds = true;
        public LightingQuality smoothLighting = LightingQuality.HIGH;
    }

    public static class ExperimentalSettings {
        public boolean displayFps = false;
        public int displayFpsPos = 2;
    }

    public static class AdvancedSettings {
        public boolean useVertexArrayObjects = true;
        public boolean useChunkMultidraw = true;
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useParticleCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useCompactVertexFormat = true;
        public boolean useBlockFaceCulling = true;
        public boolean allowDirectMemoryAccess = true;
        public boolean ignoreDriverBlacklist = false;
    }
}

