/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class FlagBlockTileRenderer
extends TileEntityRenderer<FlagBlockTile> {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public FlagBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(FlagBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        List<Pair<BannerPattern, DyeColor>> list = tile.getPatterns();
        if (list != null) {
            int lu = combinedLightIn & 0xFFFF;
            int lv = combinedLightIn >> 16 & 0xFFFF;
            int w = 24;
            int h = 16;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
            matrixStackIn.func_227863_a_(Const.rot(tile.getDirection()));
            matrixStackIn.func_227863_a_(Const.XN90);
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0625);
            long time = tile.func_145831_w().func_82737_E();
            double l = ClientConfigs.cached.FLAG_WAVELENGTH;
            long period = ClientConfigs.cached.FLAG_PERIOD;
            double wavyness = ClientConfigs.cached.FLAG_AMPLITUDE;
            double invdamping = ClientConfigs.cached.FLAG_AMPLITUDE_INCREMENT;
            BlockPos bp = tile.func_174877_v();
            float t = ((float)Math.floorMod((long)(bp.func_177958_n() * 7 + bp.func_177952_p() * 13) + time, period) + partialTicks) / (float)period;
            int segmentLen = this.minecraft.field_71474_y.field_238330_f_.func_238162_a_() >= ClientConfigs.cached.FLAG_FANCINESS.ordinal() ? 1 : w;
            for (int dX = 0; dX < w; dX += segmentLen) {
                float ang = (float)((wavyness + invdamping * (double)dX) * (double)MathHelper.func_76126_a((float)((float)((double)dX / l - (double)(t * 2.0f * (float)Math.PI)))));
                FlagBlockTileRenderer.renderPatterns(bufferIn, matrixStackIn, list, lu, lv, dX, w, h, segmentLen, ang);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ang));
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)((float)segmentLen / 16.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-ang));
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public static void renderPatterns(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, List<Pair<BannerPattern, DyeColor>> list, int combinedLightIn) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        FlagBlockTileRenderer.renderPatterns(bufferIn, matrixStackIn, list, lu, lv, 0, 24, 16, 24, 0.0f);
    }

    private static void renderPatterns(IRenderTypeBuffer bufferIn, MatrixStack matrixStackIn, List<Pair<BannerPattern, DyeColor>> list, int lu, int lv, int dX, int w, int h, int segmentlen, float ang) {
        for (int p = 0; p < list.size(); ++p) {
            RenderMaterial rendermaterial = Materials.FLAG_MATERIALS.get(list.get(p).getFirst());
            SpriteAwareVertexBuilder builder = (SpriteAwareVertexBuilder)rendermaterial.func_229311_a_(bufferIn, p == 0 ? RenderType::func_228634_a_ : RenderType::func_228650_h_);
            matrixStackIn.func_227860_a_();
            int color = ((DyeColor)list.get(p).getSecond()).getColorValue();
            float b = (float)NativeImage.func_227791_b_((int)color) / 255.0f;
            float g = (float)NativeImage.func_227793_c_((int)color) / 255.0f;
            float r = (float)NativeImage.func_227795_d_((int)color) / 255.0f;
            FlagBlockTileRenderer.renderCurvedSegment((IVertexBuilder)builder, rendermaterial.func_229314_c_(), matrixStackIn, ang, dX, segmentlen, h, lu, lv, dX + segmentlen >= w, r, g, b);
            matrixStackIn.func_227865_b_();
        }
    }

    private static void renderCurvedSegment(IVertexBuilder builder, TextureAtlasSprite sprite, MatrixStack matrixStack, float angle, int dX, int length, int height, int lu, int lv, boolean end, float r, float g, float b) {
        float textW = 32.0f;
        float textH = 16.0f;
        float u = (float)dX / textW;
        float v = 0.0f;
        float maxV = v + (float)height / textH;
        float maxU = u + (float)length / textW;
        float w = 0.0625f;
        float hw = w / 2.0f;
        float l = (float)length / 16.0f;
        float h = (float)height / 16.0f;
        float pU = RendererUtil.getRelativeU(sprite, maxU - w);
        float pV = RendererUtil.getRelativeV(sprite, maxV - w);
        maxU = RendererUtil.getRelativeU(sprite, maxU);
        u = RendererUtil.getRelativeU(sprite, u);
        maxV = RendererUtil.getRelativeV(sprite, maxV);
        v = RendererUtil.getRelativeV(sprite, v);
        Quaternion rotation = Vector3f.field_229181_d_.func_229187_a_(angle);
        Quaternion rotation2 = Vector3f.field_229181_d_.func_229187_a_(-angle);
        int nx = 1;
        boolean nz = false;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)hw, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, maxV, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        matrixStack.func_227863_a_(rotation);
        matrixStack.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(-hw), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, maxV, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        matrixStack.func_227863_a_(rotation);
        matrixStack.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)hw, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.func_227861_a_((double)(-w), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.func_227863_a_(rotation);
        matrixStack.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.func_227863_a_(rotation2);
        matrixStack.func_227861_a_((double)w, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(-hw), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, pV, r, g, b, 1.0f, lu, lv, -1.0f, 0.0f, 0.0f);
        matrixStack.func_227861_a_((double)w, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, maxV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.func_227863_a_(rotation);
        matrixStack.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.func_227863_a_(rotation2);
        matrixStack.func_227861_a_((double)(-w), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, pV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.func_227865_b_();
        if (end) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(rotation);
            matrixStack.func_227861_a_(0.0, 0.0, (double)l);
            matrixStack.func_227863_a_(rotation2);
            matrixStack.func_227861_a_((double)(-hw), 0.0, 0.0);
            RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, pU, v, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, pU, maxV, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStack.func_227861_a_((double)w, 0.0, 0.0);
            RendererUtil.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            RendererUtil.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }
}

