/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class AutomataEntityTransferPlugin
extends AutomataCorePlugin {
    private static final String ENTITY_NBT_KEY = "storedEntity";
    private final Predicate<Entity> suitableEntity;

    public AutomataEntityTransferPlugin(AutomataCorePeripheral automataCore, Predicate<Entity> suitableEntity) {
        super(automataCore);
        this.suitableEntity = suitableEntity;
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.CAPTURE_ANIMAL};
    }

    protected boolean isEntityInside() {
        return !((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().func_74775_l(ENTITY_NBT_KEY).isEmpty();
    }

    protected void saveEntity(CompoundNBT data) {
        ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().func_218657_a(ENTITY_NBT_KEY, (INBT)data);
    }

    protected CompoundNBT getEntity() {
        return ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().func_74775_l(ENTITY_NBT_KEY);
    }

    protected void removeEntity() {
        ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().func_82580_o(ENTITY_NBT_KEY);
    }

    @javax.annotation.Nullable
    protected Entity extractEntity() {
        CompoundNBT data = this.getEntity();
        EntityType type = EntityType.func_220327_a((String)data.func_74779_i("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.func_200721_a(((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getWorld());
            if (entity == null) {
                return null;
            }
            entity.func_70020_e(data);
            return entity;
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult captureAnimal() throws LuaException {
        RayTraceResult entityHit = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).withPlayer(player -> player.findHit(false, true, this.suitableEntity));
        if (entityHit.func_216346_c() == RayTraceResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "Nothing found"});
        }
        return this.automataCore.withOperation(SingleOperation.CAPTURE_ANIMAL, context -> {
            LivingEntity entity = (LivingEntity)((EntityRayTraceResult)entityHit).func_216348_a();
            if (entity instanceof PlayerEntity || !entity.func_70089_S()) {
                return MethodResult.of((Object[])new Object[]{null, "Unsuitable entity"});
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("entity", EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString());
            entity.func_189511_e(nbt);
            entity.func_70106_y();
            this.saveEntity(nbt);
            return MethodResult.of((Object)true);
        }, context -> {
            if (this.isEntityInside()) {
                return MethodResult.of((Object[])new Object[]{null, "Another entity already captured"});
            }
            return null;
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult releaseAnimal() {
        if (!this.isEntityInside()) {
            return MethodResult.of((Object[])new Object[]{null, "No entity is stored"});
        }
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        this.automataCore.addRotationCycle();
        Entity extractedEntity = this.extractEntity();
        if (extractedEntity == null) {
            return MethodResult.of((Object[])new Object[]{null, "Problem with entity unpacking"});
        }
        BlockPos blockPos = owner.getPos().func_177971_a(owner.getFacing().func_176730_m());
        extractedEntity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.removeEntity();
        owner.getWorld().func_217376_c(extractedEntity);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCapturedAnimal() {
        Entity extractedEntity = this.extractEntity();
        return MethodResult.of(LuaConverter.completeEntityToLua(extractedEntity, ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getToolInMainHand()));
    }
}

