/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.integrateddynamics;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.OperatorVariableFacade;
import org.cyclops.integrateddynamics.tileentity.TileVariablestore;

public class VariableStoreIntegration
extends TileEntityIntegrationPeripheral<TileVariablestore> {
    public VariableStoreIntegration(TileEntity entity) {
        super(entity);
    }

    public String getType() {
        return "variableStore";
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, HashMap<String, Object>> list() {
        LazyOptional lazyContainer = ((TileVariablestore)this.tileEntity).getCapability(VariableContainerConfig.CAPABILITY);
        return lazyContainer.map(container -> container.getVariableCache().entrySet().stream().map(entry -> {
            HashMap<String, Object> variableData = new HashMap<String, Object>(3);
            variableData.put("id", ((IVariableFacade)entry.getValue()).getId());
            variableData.put("label", ((IVariableFacade)entry.getValue()).getLabel());
            variableData.put("type", ((IVariableFacade)entry.getValue()).getOutputType().getTypeName());
            variableData.put("dynamic", entry.getValue() instanceof OperatorVariableFacade);
            return new AbstractMap.SimpleImmutableEntry((Integer)entry.getKey() + 1, variableData);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(new HashMap());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult read(int slot) {
        int realSlot = slot - 1;
        LazyOptional lazyContainer = ((TileVariablestore)this.tileEntity).getCapability(VariableContainerConfig.CAPABILITY);
        return lazyContainer.map(container -> {
            IValue value;
            IVariableFacade facade = (IVariableFacade)container.getVariableCache().get(realSlot);
            if (facade == null) {
                return MethodResult.of((Object[])new Object[]{null, String.format("Slot %d is empty", realSlot)});
            }
            if (((TileVariablestore)this.tileEntity).getNetwork() == null) {
                return MethodResult.of((Object[])new Object[]{null, "Integred Dynamic network is configured incorrect"});
            }
            IVariable variable = facade.getVariable(NetworkHelpers.getPartNetworkChecked((INetwork)((TileVariablestore)this.tileEntity).getNetwork()));
            if (variable == null) {
                return MethodResult.of((Object[])new Object[]{null, "Variable cannot be accessed"});
            }
            try {
                value = variable.getValue();
            }
            catch (EvaluationException e) {
                return MethodResult.of((Object[])new Object[]{null, e.getErrorMessage().toString()});
            }
            HashMap<String, Object> valueData = new HashMap<String, Object>(4);
            valueData.put("type", value.getType().getTypeName());
            valueData.put("id", facade.getId());
            valueData.put("label", facade.getLabel());
            valueData.put("value", NBTUtil.toLua((INBT)value.getType().serialize(value)));
            valueData.put("dynamic", facade instanceof OperatorVariableFacade);
            return MethodResult.of(valueData);
        }).orElse(MethodResult.of((Object[])new Object[]{null, "Problem with access to variable container"}));
    }
}

