/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.shared.peripheral.generic.data.DataHelpers;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.common.tile.TileEntityChemicalTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ChemicalTankIntegration
extends TileEntityIntegrationPeripheral<TileEntityChemicalTank> {
    public ChemicalTankIntegration(TileEntity entity) {
        super(entity);
    }

    public String getType() {
        return "chemicalTank";
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getStored() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("name", DataHelpers.getId((IForgeRegistryEntry)this.getTank().getStack().getType()));
        result.put("amount", this.getTank().getStored());
        result.put("type", this.getMergedTank().getCurrent().name());
        return result;
    }

    @LuaFunction(mainThread=true)
    public final long getCapacity() {
        return this.getTank().getCapacity();
    }

    @LuaFunction
    public final String getTier() {
        return ((TileEntityChemicalTank)this.tileEntity).getTier().name();
    }

    @LuaFunction(mainThread=true)
    public final double getFilledPercentage() {
        return (double)this.getTank().getStored() / (double)this.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getNeeded() {
        return this.getTank().getNeeded();
    }

    private IChemicalTank<?, ?> getTank() {
        MergedChemicalTank mergedTank = this.getMergedTank();
        if (mergedTank.getCurrent() != MergedChemicalTank.Current.EMPTY) {
            return mergedTank.getTankFromCurrent(mergedTank.getCurrent());
        }
        return mergedTank.getGasTank();
    }

    private MergedChemicalTank getMergedTank() {
        return ((TileEntityChemicalTank)this.tileEntity).getChemicalTank();
    }
}

