/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.client;

import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.chunkloader.tile.TileSpotLoader;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;

public class TileChunkLoaderRenderer
extends TileEntityRenderer<TileChunkLoaderBase> {
    public static final RenderType laserType = RenderType.func_228632_a_((String)"lasers", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228725_a_(new RenderState.TexturingState("disable_lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228717_a_(RenderState.field_228501_K_).func_228728_a_(false));
    public static final RenderType pearlType = CCModelLibrary.getIcos4RenderType((ResourceLocation)new ResourceLocation("chickenchunks:textures/hedronmap.png"), (boolean)false);

    public TileChunkLoaderRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileChunkLoaderBase tile, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        double size;
        double height;
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedOverlay;
        ccrs.overlay = packedOverlay;
        double rot = ClientUtils.getRenderTime() * 2.0;
        double updown = ClientUtils.getRenderTime() % 50.0 / 25.0;
        updown = (float)Math.sin(updown * 3.141593);
        updown *= 0.2;
        if (tile instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)tile;
            rot /= Math.pow(ctile.radius, 0.2);
            height = 0.9;
            size = 0.08;
        } else if (tile instanceof TileSpotLoader) {
            height = 0.5;
            size = 0.05;
        } else {
            return;
        }
        TileChunkLoaderBase.RenderInfo renderInfo = tile.renderInfo;
        double active = (double)renderInfo.activationCounter / 20.0;
        if (tile.active && renderInfo.activationCounter < 20) {
            active += (double)partialTicks / 20.0;
        } else if (!tile.active && renderInfo.activationCounter > 0) {
            active -= (double)partialTicks / 20.0;
        }
        if (renderInfo.showLasers) {
            IVertexBuilder builder = getter.getBuffer(laserType);
            this.drawRays(builder, mat, rot, updown, tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), tile.getChunks());
        }
        rot = ClientUtils.getRenderTime() * active / 3.0;
        Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)mat, (Vector3)new Vector3(0.5, height + (updown + 0.3) * active, 0.5), (Rotation)new Rotation(rot, Vector3.Y_POS), (double)size);
        ccrs.brightness = 0xF000F0;
        ccrs.bind(pearlType, getter);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.reset();
    }

    public Point2D.Double findIntersection(Line2D line1, Line2D line2) {
        double xD1 = line1.getX2() - line1.getX1();
        double yD1 = line1.getY2() - line1.getY1();
        double xD2 = line2.getX2() - line2.getX1();
        double yD2 = line2.getY2() - line2.getY1();
        double xD3 = line1.getX1() - line2.getX1();
        double yD3 = line1.getY1() - line2.getY1();
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        double div = yD2 * xD1 - xD2 * yD1;
        if (div == 0.0) {
            return null;
        }
        double ua = (xD2 * yD3 - yD2 * xD3) / div;
        pt.x = line1.getX1() + ua * xD1;
        pt.y = line1.getY1() + ua * yD1;
        if (this.ptOnLineInSegment(pt, line1) && this.ptOnLineInSegment(pt, line2)) {
            return pt;
        }
        return null;
    }

    public boolean ptOnLineInSegment(Point2D point, Line2D line) {
        return point.getX() >= Math.min(line.getX1(), line.getX2()) && point.getX() <= Math.max(line.getX1(), line.getX2()) && point.getY() >= Math.min(line.getY1(), line.getY2()) && point.getY() <= Math.max(line.getY1(), line.getY2());
    }

    public void drawRays(IVertexBuilder builder, Matrix4 mat, double rot, double updown, int x, int y, int z, Collection<ChunkPos> chunkSet) {
        int cx = x >> 4 << 4;
        int cz = z >> 4 << 4;
        double[] distances = new double[4];
        Point2D.Double center = new Point2D.Double(cx + 8, cz + 8);
        int[][] coords = new int[][]{{0, 0}, {16, 0}, {16, 16}, {0, 16}};
        Point2D.Double[] absRays = new Point2D.Double[4];
        for (int ray = 0; ray < 4; ++ray) {
            double rayAngle = Math.toRadians(rot + (double)(90 * ray));
            absRays[ray] = new Point2D.Double(Math.sin(rayAngle), Math.cos(rayAngle));
        }
        Line2D.Double[] rays = new Line2D.Double[]{new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[0].x, center.y + 1600.0 * absRays[0].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[1].x, center.y + 1600.0 * absRays[1].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[2].x, center.y + 1600.0 * absRays[2].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[3].x, center.y + 1600.0 * absRays[3].y)};
        for (ChunkPos pair : chunkSet) {
            int chunkBlockX = pair.field_77276_a << 4;
            int chunkBlockZ = pair.field_77275_b << 4;
            for (int side = 0; side < 4; ++side) {
                int[] offset1 = coords[side];
                int[] offset2 = coords[(side + 1) % 4];
                Line2D.Double line1 = new Line2D.Double(chunkBlockX + offset1[0], chunkBlockZ + offset1[1], chunkBlockX + offset2[0], chunkBlockZ + offset2[1]);
                for (int ray = 0; ray < 4; ++ray) {
                    Point2D.Double isct = this.findIntersection(line1, rays[ray]);
                    if (isct == null) continue;
                    isct.setLocation(isct.x - center.x, isct.y - center.y);
                    double lenPow2 = isct.x * isct.x + isct.y * isct.y;
                    if (!(lenPow2 > distances[ray])) continue;
                    distances[ray] = lenPow2;
                }
            }
        }
        Matrix4 hozMat = mat.copy();
        hozMat.translate((double)(cx - x + 8), updown + 2.0, (double)(cz - z + 8));
        hozMat.rotate(rot * 0.017453292519943, Vector3.Y_POS);
        for (int ray = 0; ray < 4; ++ray) {
            distances[ray] = Math.sqrt(distances[ray]);
            hozMat.rotate(1.5707963267948701, Vector3.Y_POS);
            TileChunkLoaderRenderer.renderCuboid(builder, hozMat, new Cuboid6(0.0, -0.05, -0.05, distances[ray], 0.05, 0.05), 0.9f, 0.0f, 0.0f, 1.0f);
        }
        Matrix4 vertMat = mat.copy();
        vertMat.translate((double)(cx - x + 8), 0.0, (double)(cz - z + 8));
        for (int ray = 0; ray < 4; ++ray) {
            Matrix4 rayMat = vertMat.copy();
            rayMat.translate(absRays[ray].x * distances[ray], 0.0, absRays[ray].y * distances[ray]);
            TileChunkLoaderRenderer.renderCuboid(builder, rayMat, new Cuboid6(-0.05, 0.0, -0.05, 0.05, 256.0, 0.05), 0.9f, 0.0f, 0.0f, 1.0f);
        }
        double toCenter = Math.sqrt(((double)cx + 7.5 - (double)x) * ((double)cx + 7.5 - (double)x) + 0.6400000000000001 + ((double)cz + 7.5 - (double)z) * ((double)cz + 7.5 - (double)z));
        Matrix4 centerMat = mat.copy();
        centerMat.translate(0.5, 1.2 + updown, 0.5);
        centerMat.rotate((double)((float)(Math.atan2((double)cx + 7.5 - (double)x, (double)cz + 7.5 - (double)z) * 180.0 / 3.1415) + 90.0f) * 0.017453292519943, Vector3.Y_POS);
        centerMat.rotate((double)((float)(-Math.asin(0.8 / toCenter) * 180.0 / 3.1415)) * 0.017453292519943, Vector3.Z_POS);
        TileChunkLoaderRenderer.renderCuboid(builder, centerMat, new Cuboid6(-toCenter, -0.03, -0.03, 0.0, 0.03, 0.03), 0.0f, 0.9f, 0.0f, 1.0f);
    }

    private static void renderCuboid(IVertexBuilder builder, Matrix4 mat, Cuboid6 cuboid, float r, float g, float b, float a) {
        RenderUtils.bufferCuboidSolid((IVertexBuilder)new TransformingVertexBuilder(builder, (Transformation)mat), (Cuboid6)cuboid, (float)r, (float)g, (float)b, (float)a);
    }
}

