/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.helpers;

import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.helpers.Config;
import net.quetzi.morpheus.helpers.DateHandler;

public class SleepChecker {
    private HashMap<RegistryKey<World>, Boolean> alertSent = new HashMap();

    public void updatePlayerStates(World world) {
        if (world.func_217369_A().size() > 1) {
            for (PlayerEntity player : world.func_217369_A()) {
                String username = player.func_146103_bH().getName();
                RegistryKey playerWorld = player.func_130014_f_().func_234923_W_();
                if (player.func_71026_bH() && !Morpheus.playerSleepStatus.get(playerWorld).isPlayerSleeping(username)) {
                    Morpheus.playerSleepStatus.get(playerWorld).setPlayerAsleep(username);
                    this.alertPlayers(this.createAlert((RegistryKey<World>)playerWorld, player.func_145748_c_().getString(), (String)Config.SERVER.onSleepText.get()), world);
                    continue;
                }
                if (player.func_71026_bH() || !Morpheus.playerSleepStatus.get(playerWorld).isPlayerSleeping(username)) continue;
                Morpheus.playerSleepStatus.get(playerWorld).setPlayerAwake(username);
                if (world.func_72935_r() || this.alertSent.get(world.func_234923_W_()).booleanValue()) continue;
                this.alertPlayers(this.createAlert((RegistryKey<World>)playerWorld, player.func_145748_c_().getString(), (String)Config.SERVER.onWakeText.get()), world);
            }
            if (this.areEnoughPlayersAsleep((RegistryKey<World>)world.func_234923_W_())) {
                if (!this.alertSent.containsKey(world.func_234923_W_())) {
                    this.alertSent.put((RegistryKey<World>)world.func_234923_W_(), false);
                }
                this.advanceToMorning(world);
            } else {
                this.alertSent.put((RegistryKey<World>)world.func_234923_W_(), false);
            }
        }
    }

    private void alertPlayers(StringTextComponent alert, World world) {
        if (alert != null && ((Boolean)Config.SERVER.alertEnabled.get()).booleanValue()) {
            for (PlayerEntity player : world.func_217369_A()) {
                player.func_145747_a((ITextComponent)alert, player.func_110124_au());
            }
        }
    }

    private StringTextComponent createAlert(RegistryKey<World> dimension, String username, String text) {
        Morpheus.logger.info(String.format("%s %s %s", username, text, Morpheus.playerSleepStatus.get(dimension).toString()));
        return new StringTextComponent(String.format("%s%s%s %s %s", TextFormatting.WHITE, username, TextFormatting.GOLD, text, Morpheus.playerSleepStatus.get(dimension).toString()));
    }

    private void advanceToMorning(World world) {
        try {
            MorpheusRegistry.registry.get(world.func_234923_W_()).startNewDay();
        }
        catch (Exception e) {
            Morpheus.logger.error("Exception caught while starting a new day for dimension " + world.func_234923_W_());
            e.printStackTrace();
        }
        if (!this.alertSent.get(world.func_234923_W_()).booleanValue()) {
            this.alertPlayers(new StringTextComponent(DateHandler.getMorningText()), world);
            Morpheus.playerSleepStatus.get(world.func_234923_W_()).wakeAllPlayers();
            this.alertSent.put((RegistryKey<World>)world.func_234923_W_(), true);
        }
        if (world instanceof ServerWorld && world.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
            ((ServerWorld)world).func_241113_a_(((ServerWorldInfo)world.func_72912_H()).func_230395_g_(), 0, false, false);
        }
    }

    private boolean areEnoughPlayersAsleep(RegistryKey<World> dimension) {
        if (Morpheus.playerSleepStatus.get(dimension).getSleepingPlayers() > 0) {
            return MorpheusRegistry.registry.get(dimension) != null && Morpheus.playerSleepStatus.get(dimension).getPercentSleeping() >= (Integer)Config.SERVER.perc.get();
        }
        return false;
    }
}

