/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.client.model.DynamicFluidContainerModel;
import cofh.lib.item.IColorableItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoreClientSetupEvents {
    private static final List<Item> COLORABLE_ITEMS = new ArrayList<Item>();

    private CoreClientSetupEvents() {
    }

    @SubscribeEvent
    public static void colorSetupItem(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        for (Item colorable : COLORABLE_ITEMS) {
            colors.func_199877_a(((IColorableItem)colorable)::getColor, new IItemProvider[]{colorable});
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("cofh_core", "dynamic_fluid"), (IModelLoader)new DynamicFluidContainerModel.Loader());
    }

    public static void addColorable(Item colorable) {
        if (colorable instanceof IColorableItem) {
            COLORABLE_ITEMS.add(colorable);
        }
    }
}

