/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Palette;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public final class PrintoutRenderer {
    private static final ResourceLocation BG = new ResourceLocation("computercraft", "textures/gui/printout.png");
    private static final float BG_SIZE = 256.0f;
    public static final int X_SIZE = 172;
    public static final int Y_SIZE = 209;
    public static final int X_TEXT_MARGIN = 13;
    public static final int Y_TEXT_MARGIN = 11;
    private static final int X_FOLD_SIZE = 12;
    public static final int COVER_SIZE = 12;
    private static final int COVER_Y = 209;
    private static final int COVER_X = 220;

    private PrintoutRenderer() {
    }

    public static void drawText(Matrix4f transform, IRenderTypeBuffer renderer, int x, int y, int start, TextBuffer[] text, TextBuffer[] colours) {
        IVertexBuilder buffer = renderer.getBuffer(FixedWidthFontRenderer.TYPE);
        for (int line = 0; line < 21 && line < text.length; ++line) {
            FixedWidthFontRenderer.drawString(transform, buffer, x, y + line * 9, text[start + line], colours[start + line], null, Palette.DEFAULT, false, 0.0f, 0.0f);
        }
    }

    public static void drawText(Matrix4f transform, IRenderTypeBuffer renderer, int x, int y, int start, String[] text, String[] colours) {
        IVertexBuilder buffer = renderer.getBuffer(FixedWidthFontRenderer.TYPE);
        for (int line = 0; line < 21 && line < text.length; ++line) {
            FixedWidthFontRenderer.drawString(transform, buffer, x, y + line * 9, new TextBuffer(text[start + line]), new TextBuffer(colours[start + line]), null, Palette.DEFAULT, false, 0.0f, 0.0f);
        }
    }

    public static void drawBorder(Matrix4f transform, IRenderTypeBuffer renderer, float x, float y, float z, int page, int pages, boolean isBook) {
        int n;
        int leftPages = page;
        int rightPages = pages - page - 1;
        IVertexBuilder buffer = renderer.getBuffer(Type.TYPE);
        if (isBook) {
            float offset = PrintoutRenderer.offsetAt(pages);
            float left = x - 4.0f - offset;
            float right = x + 172.0f + offset - 4.0f;
            PrintoutRenderer.drawTexture(transform, buffer, left - 4.0f, y - 8.0f, z - 0.02f, 220.0f, 0.0f, 12.0f, 233.0f);
            PrintoutRenderer.drawTexture(transform, buffer, right, y - 8.0f, z - 0.02f, 232.0f, 0.0f, 12.0f, 233.0f);
            PrintoutRenderer.drawTexture(transform, buffer, x - offset, y, z - 0.02f, 172.0f + offset * 2.0f, 209.0f, 226.0f, 12.0f, 12.0f, 209.0f);
            float borderX = left;
            while (borderX < right) {
                double thisWidth = Math.min(right - borderX, 172.0f);
                PrintoutRenderer.drawTexture(transform, buffer, borderX, y - 8.0f, z - 0.02f, 0.0f, 209.0f, (float)thisWidth, 12.0f);
                PrintoutRenderer.drawTexture(transform, buffer, borderX, y + 209.0f - 4.0f, z - 0.02f, 0.0f, 221.0f, (float)thisWidth, 12.0f);
                borderX = (float)((double)borderX + thisWidth);
            }
        }
        PrintoutRenderer.drawTexture(transform, buffer, x, y, z, 24.0f, 0.0f, 86.0f, 209.0f);
        for (n = 0; n <= leftPages; ++n) {
            PrintoutRenderer.drawTexture(transform, buffer, x - PrintoutRenderer.offsetAt(n), y, z - 0.001f * (float)n, n == leftPages ? 0.0f : 12.0f, 0.0f, 12.0f, 209.0f);
        }
        PrintoutRenderer.drawTexture(transform, buffer, x + 86.0f, y, z, 110.0f, 0.0f, 86.0f, 209.0f);
        for (n = 0; n <= rightPages; ++n) {
            PrintoutRenderer.drawTexture(transform, buffer, x + 160.0f + PrintoutRenderer.offsetAt(n), y, z - 0.001f * (float)n, 196 + (n == rightPages ? 12 : 0), 0.0f, 12.0f, 209.0f);
        }
    }

    private static void drawTexture(Matrix4f matrix, IVertexBuilder buffer, float x, float y, float z, float u, float v, float width, float height) {
        buffer.func_227888_a_(matrix, x, y + height, z).func_225583_a_(u / 256.0f, (v + height) / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_225583_a_((u + width) / 256.0f, (v + height) / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, z).func_225583_a_((u + width) / 256.0f, v / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z).func_225583_a_(u / 256.0f, v / 256.0f).func_181675_d();
    }

    private static void drawTexture(Matrix4f matrix, IVertexBuilder buffer, float x, float y, float z, float width, float height, float u, float v, float tWidth, float tHeight) {
        buffer.func_227888_a_(matrix, x, y + height, z).func_225583_a_(u / 256.0f, (v + tHeight) / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_225583_a_((u + tWidth) / 256.0f, (v + tHeight) / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, z).func_225583_a_((u + tWidth) / 256.0f, v / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z).func_225583_a_(u / 256.0f, v / 256.0f).func_181675_d();
    }

    public static float offsetAt(int page) {
        return (float)(32.0 * (1.0 - Math.pow(1.2, -page)));
    }

    static /* synthetic */ ResourceLocation access$000() {
        return BG;
    }

    private static final class Type
    extends RenderState {
        static final RenderType TYPE = RenderType.func_228633_a_((String)"printout_background", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)1024, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PrintoutRenderer.access$000(), false, false)).func_228713_a_(field_228517_i_).func_228719_a_(field_228529_u_).func_228728_a_(false));

        private Type(String name, Runnable setup, Runnable destroy) {
            super(name, setup, destroy);
        }
    }
}

