/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nonnull;

public class EncodedReadableHandle
extends HandleGeneric {
    private static final int BUFFER_SIZE = 8192;
    private final BufferedReader reader;

    public EncodedReadableHandle(@Nonnull BufferedReader reader, @Nonnull TrackingCloseable closable) {
        super(closable);
        this.reader = reader;
    }

    public EncodedReadableHandle(@Nonnull BufferedReader reader) {
        this(reader, new TrackingCloseable.Impl(reader));
    }

    @LuaFunction
    public final Object[] readLine(Optional<Boolean> withTrailingArg) throws LuaException {
        this.checkOpen();
        boolean withTrailing = withTrailingArg.orElse(false);
        try {
            String line = this.reader.readLine();
            if (line != null) {
                if (withTrailing) {
                    line = line + "\n";
                }
                return new Object[]{line};
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @LuaFunction
    public final Object[] readAll() throws LuaException {
        this.checkOpen();
        try {
            StringBuilder result = new StringBuilder();
            String line = this.reader.readLine();
            while (line != null) {
                result.append(line);
                line = this.reader.readLine();
                if (line == null) continue;
                result.append("\n");
            }
            return new Object[]{result.toString()};
        }
        catch (IOException e) {
            return null;
        }
    }

    @LuaFunction
    public final Object[] read(Optional<Integer> countA) throws LuaException {
        this.checkOpen();
        try {
            int count = countA.orElse(1);
            if (count < 0) {
                throw new LuaException("Cannot read a negative number of characters");
            }
            if (count <= 8192) {
                Object[] objectArray;
                char[] chars = new char[count];
                int read = this.reader.read(chars);
                if (read < 0) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = new String(chars, 0, read);
                }
                return objectArray;
            }
            char[] buffer = new char[8192];
            int read = this.reader.read(buffer, 0, Math.min(buffer.length, count));
            if (read < 0) {
                return null;
            }
            StringBuilder out = new StringBuilder(read);
            out.append(buffer, 0, read);
            for (int totalRead = read; read >= 8192 && totalRead < count && (read = this.reader.read(buffer, 0, Math.min(8192, count - totalRead))) >= 0; totalRead += read) {
                out.append(buffer, 0, read);
            }
            return new Object[]{out.toString()};
        }
        catch (IOException e) {
            return null;
        }
    }

    public static BufferedReader openUtf8(ReadableByteChannel channel) {
        return EncodedReadableHandle.open(channel, StandardCharsets.UTF_8);
    }

    public static BufferedReader open(ReadableByteChannel channel, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new BufferedReader(Channels.newReader(channel, decoder, -1));
    }
}

