/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.util.StringUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class DiskDrivePeripheral
implements IPeripheral {
    private final TileDiskDrive diskDrive;

    DiskDrivePeripheral(TileDiskDrive diskDrive) {
        this.diskDrive = diskDrive;
    }

    @Override
    @Nonnull
    public String getType() {
        return "drive";
    }

    @LuaFunction
    public final boolean isDiskPresent() {
        return !this.diskDrive.getDiskStack().func_190926_b();
    }

    @LuaFunction
    public final Object[] getDiskLabel() {
        Object[] objectArray;
        ItemStack stack = this.diskDrive.getDiskStack();
        IMedia media = MediaProviders.get(stack);
        if (media == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = media.getLabel(stack);
        }
        return objectArray;
    }

    @LuaFunction(mainThread=true)
    public final void setDiskLabel(Optional<String> labelA) throws LuaException {
        String label = labelA.orElse(null);
        ItemStack stack = this.diskDrive.getDiskStack();
        IMedia media = MediaProviders.get(stack);
        if (media == null) {
            return;
        }
        if (!media.setLabel(stack, StringUtil.normaliseLabel(label))) {
            throw new LuaException("Disk label cannot be changed");
        }
        this.diskDrive.setDiskStack(stack);
    }

    @LuaFunction
    public final boolean hasData(IComputerAccess computer) {
        return this.diskDrive.getDiskMountPath(computer) != null;
    }

    @LuaFunction
    @Nullable
    public final String getMountPath(IComputerAccess computer) {
        return this.diskDrive.getDiskMountPath(computer);
    }

    @LuaFunction
    public final boolean hasAudio() {
        ItemStack stack = this.diskDrive.getDiskStack();
        IMedia media = MediaProviders.get(stack);
        return media != null && media.getAudio(stack) != null;
    }

    @LuaFunction
    @Nullable
    public final Object getAudioTitle() {
        ItemStack stack = this.diskDrive.getDiskStack();
        IMedia media = MediaProviders.get(stack);
        return media != null ? media.getAudioTitle(stack) : Boolean.valueOf(false);
    }

    @LuaFunction
    public final void playAudio() {
        this.diskDrive.playDiskAudio();
    }

    @LuaFunction
    public final void stopAudio() {
        this.diskDrive.stopDiskAudio();
    }

    @LuaFunction
    public final void ejectDisk() {
        this.diskDrive.ejectDisk();
    }

    @LuaFunction
    public final Object[] getDiskID() {
        Object[] objectArray;
        ItemStack disk = this.diskDrive.getDiskStack();
        if (disk.func_77973_b() instanceof ItemDisk) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ItemDisk.getDiskID(disk);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Override
    public void attach(@Nonnull IComputerAccess computer) {
        this.diskDrive.mount(computer);
    }

    @Override
    public void detach(@Nonnull IComputerAccess computer) {
        this.diskDrive.unmount(computer);
    }

    @Override
    public boolean equals(IPeripheral other) {
        return this == other || other instanceof DiskDrivePeripheral && ((DiskDrivePeripheral)other).diskDrive == this.diskDrive;
    }

    @Override
    @Nonnull
    public Object getTarget() {
        return this.diskDrive;
    }
}

