/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHook;
import org.squiddev.cobalt.function.LuaFunction;

public final class DebugState {
    public static final int MAX_SIZE = Short.MAX_VALUE;
    public static final int MAX_JAVA_SIZE = 200;
    public static final int DEFAULT_SIZE = 8;
    private static final DebugFrame[] EMPTY = new DebugFrame[0];
    private final LuaState state;
    int top = -1;
    private int javaCount = 0;
    private DebugFrame[] stack = EMPTY;
    public DebugHook hookfunc;
    public boolean hookcall;
    public boolean hookline;
    public boolean hookrtrn;
    public boolean inhook;
    public int hookcount;
    public int hookcodes;

    public DebugState(LuaState state) {
        this.state = state;
    }

    public LuaState getLuaState() {
        return this.state;
    }

    public DebugFrame pushJavaInfo() throws LuaError {
        int javaTop = this.javaCount + 1;
        if (javaTop >= 200) {
            throw new LuaError("stack overflow");
        }
        DebugFrame frame = this.pushInfo();
        this.javaCount = javaTop;
        return frame;
    }

    public DebugFrame pushInfo() throws LuaError {
        int top = this.top + 1;
        DebugFrame[] frames = this.stack;
        int length = frames.length;
        if (top >= length) {
            if (top >= Short.MAX_VALUE) {
                throw new LuaError("stack overflow");
            }
            int newSize = length == 0 ? 8 : Math.min(Short.MAX_VALUE, length + length / 2);
            DebugFrame[] f = new DebugFrame[newSize];
            System.arraycopy(frames, 0, f, 0, length);
            for (int i = frames.length; i < newSize; ++i) {
                f[i] = new DebugFrame(i > 0 ? f[i - 1] : null);
            }
            this.stack = f;
            frames = f;
        }
        this.top = top;
        return frames[top];
    }

    public void popInfo() {
        DebugFrame frame = this.stack[this.top--];
        if ((frame.flags & 0x1008) != 0) {
            --this.javaCount;
        }
        assert (this.javaCount >= 0);
        frame.clear();
    }

    public void setHook(DebugHook func, boolean call, boolean line, boolean rtrn, int count) {
        this.hookcount = count;
        this.hookcall = call;
        this.hookline = line;
        this.hookrtrn = rtrn;
        this.hookfunc = func;
    }

    public DebugFrame getStack() {
        return this.top >= 0 ? this.stack[this.top] : null;
    }

    public DebugFrame getStackUnsafe() {
        return this.stack[this.top];
    }

    public DebugFrame getFrame(int level) {
        return level >= 0 && level <= this.top ? this.stack[this.top - level] : null;
    }

    public DebugFrame findDebugInfo(LuaFunction func) {
        int i = this.top - 1;
        while (--i >= 0) {
            if (this.stack[i].func != func) continue;
            return this.stack[i];
        }
        return new DebugFrame(func);
    }

    public void hookCall(DebugFrame frame) throws LuaError, UnwindThrowable {
        this.inhook = true;
        frame.flags |= 4;
        try {
            this.hookfunc.onCall(this.state, this, frame);
        }
        catch (RuntimeException | LuaError e) {
            this.inhook = false;
            throw e;
        }
        this.inhook = false;
        frame.flags &= 0xFFFFFFFB;
    }

    void hookReturn(DebugFrame frame) throws LuaError, UnwindThrowable {
        this.inhook = true;
        frame.flags |= 4;
        try {
            this.hookfunc.onReturn(this.state, this, frame);
        }
        catch (RuntimeException | LuaError e) {
            this.inhook = false;
            throw e;
        }
        this.inhook = false;
        frame.flags &= 0xFFFFFFFB;
    }

    void hookInstruction(DebugFrame frame) throws LuaError, UnwindThrowable {
        this.inhook = true;
        frame.flags |= 4;
        try {
            this.hookfunc.onCount(this.state, this, frame);
        }
        catch (RuntimeException | LuaError e) {
            this.inhook = false;
            throw e;
        }
        catch (UnwindThrowable e) {
            frame.flags |= 0x40;
            throw e;
        }
        this.inhook = false;
        frame.flags &= 0xFFFFFFFB;
    }

    void hookLine(DebugFrame frame, int newLine) throws LuaError, UnwindThrowable {
        this.inhook = true;
        frame.flags |= 4;
        try {
            this.hookfunc.onLine(this.state, this, frame, newLine);
        }
        catch (RuntimeException | LuaError e) {
            this.inhook = false;
            throw e;
        }
        catch (UnwindThrowable e) {
            frame.flags |= 0x844;
            throw e;
        }
        this.inhook = false;
        frame.flags &= 0xFFFFFFFB;
    }
}

