/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.item;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class QuarkMusicDiscItem
extends MusicDiscItem
implements IQuarkItem {
    private final QuarkModule module;
    private final boolean isAmbient;
    private final Supplier<SoundEvent> soundSupplier;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkMusicDiscItem(int comparatorValue, Supplier<SoundEvent> sound, String name, QuarkModule module, boolean isAmbient) {
        super(comparatorValue, sound, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(Rarity.RARE));
        RegistryHelper.registerItem((Item)this, (String)("music_disc_" + name));
        this.module = module;
        this.isAmbient = isAmbient;
        this.soundSupplier = sound;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_150895_a(group, items);
        }
    }

    @Override
    public QuarkMusicDiscItem setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean playAmbientSound(BlockPos pos) {
        if (this.isAmbient) {
            Minecraft mc = Minecraft.func_71410_x();
            SoundHandler soundEngine = mc.func_147118_V();
            WorldRenderer render = mc.field_71438_f;
            SimpleSound simplesound = new SimpleSound(this.soundSupplier.get().func_187503_a(), SoundCategory.RECORDS, 4.0f, 1.0f, true, 0, ISound.AttenuationType.LINEAR, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
            render.field_147593_P.put(pos, simplesound);
            soundEngine.func_147682_a((ISound)simplesound);
            if (mc.field_71441_e != null) {
                mc.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + Math.random(), Math.random(), 0.0, 0.0);
            }
            return true;
        }
        return false;
    }
}

