/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.content.building.block.MyalitePillarBlock;
import vazkii.quark.content.world.block.MyaliteBlock;
import vazkii.quark.content.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class MoreStoneVariantsModule
extends QuarkModule {
    @Config(flag="stone_bricks")
    public boolean enableBricks = true;
    @Config(flag="stone_chiseled")
    public boolean enableChiseledBricks = true;
    @Config(flag="stone_pavement")
    public boolean enablePavement = true;
    @Config(flag="stone_pillar")
    public boolean enablePillar = true;

    @Override
    public void construct() {
        BooleanSupplier _true = () -> true;
        this.add("granite", MaterialColor.field_151664_l, _true);
        this.add("diorite", MaterialColor.field_151677_p, _true);
        this.add("andesite", MaterialColor.field_151665_m, _true);
        this.add("marble", MaterialColor.field_151677_p, () -> NewStoneTypesModule.enabledWithMarble);
        this.add("limestone", MaterialColor.field_151665_m, () -> NewStoneTypesModule.enabledWithLimestone);
        this.add("jasper", MaterialColor.field_193559_aa, () -> NewStoneTypesModule.enabledWithJasper);
        this.add("slate", MaterialColor.field_151657_g, () -> NewStoneTypesModule.enabledWithSlate);
        this.add("basalt", MaterialColor.field_151646_E, () -> NewStoneTypesModule.enabledWithVoidstone);
        this.add("myalite", MaterialColor.field_151678_z, () -> NewStoneTypesModule.enabledWithMyalite, MyaliteBlock::new, MyalitePillarBlock::new);
    }

    @Override
    public void pushFlags(ConfigFlagManager manager) {
        manager.putFlag(this, "granite", true);
        manager.putFlag(this, "diorite", true);
        manager.putFlag(this, "andesite", true);
    }

    private void add(String name, MaterialColor color, BooleanSupplier cond) {
        this.add(name, color, cond, QuarkBlock::new, QuarkPillarBlock::new);
    }

    private void add(String name, MaterialColor color, BooleanSupplier cond, QuarkBlock.Constructor<QuarkBlock> constr, QuarkBlock.Constructor<QuarkPillarBlock> pillarConstr) {
        AbstractBlock.Properties props = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f);
        QuarkBlock bricks = constr.make(name + "_bricks", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enableBricks);
        VariantHandler.addSlabStairsWall(bricks);
        constr.make("chiseled_" + name + "_bricks", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enableBricks && this.enableChiseledBricks);
        constr.make(name + "_pavement", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enablePavement);
        pillarConstr.make(name + "_pillar", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enablePillar);
    }
}

