/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.client.item;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Dimension;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.content.tweaks.module.CompassesWorkEverywhereModule;

public class CompassAngleGetter {
    private static final String TAG_CALCULATED = "quark:compass_calculated";
    private static final String TAG_WAS_IN_NETHER = "quark:compass_in_nether";
    private static final String TAG_POSITION_SET = "quark:compass_position_set";
    private static final String TAG_NETHER_TARGET_X = "quark:nether_x";
    private static final String TAG_NETHER_TARGET_Z = "quark:nether_z";

    public static void tickCompass(PlayerEntity player, ItemStack stack) {
        boolean calculated = CompassAngleGetter.isCalculated(stack);
        boolean nether = player.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)Dimension.field_236054_c_.func_240901_a_());
        if (calculated) {
            boolean isInPortal;
            boolean wasInNether = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
            BlockPos pos = player.func_233580_cy_();
            boolean bl = isInPortal = player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150427_aO;
            if (nether && !wasInNether && isInPortal) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)pos.func_177958_n());
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)pos.func_177952_p());
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)true);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)true);
            } else if (!nether && wasInNether) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false);
            }
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)true);
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)nether);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Impl
    implements IItemPropertyGetter {
        private final Angle normalAngle = new Angle();
        private final Angle unknownAngle = new Angle();

        @OnlyIn(value=Dist.CLIENT)
        public float call(@Nonnull ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            double angle;
            BlockPos lodestonePos;
            LivingEntity entity;
            if (entityIn == null && !stack.func_82839_y()) {
                return 0.0f;
            }
            if (!(!CompassesWorkEverywhereModule.enableCompassNerf || stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)CompassAngleGetter.TAG_CALCULATED, (boolean)false))) {
                return 0.0f;
            }
            boolean carried = entityIn != null;
            Object object = entity = carried ? entityIn : stack.func_82836_z();
            if (entity == null) {
                return 0.0f;
            }
            if (worldIn == null && entity != null && entity.field_70170_p instanceof ClientWorld) {
                worldIn = (ClientWorld)entity.field_70170_p;
            }
            boolean calculate = false;
            BlockPos target = new BlockPos(0, 0, 0);
            ResourceLocation dimension = worldIn.func_234923_W_().func_240901_a_();
            BlockPos blockPos = lodestonePos = CompassItem.func_234670_d_((ItemStack)stack) ? this.getLodestonePosition((World)worldIn, stack.func_196082_o()) : null;
            if (lodestonePos != null) {
                calculate = true;
                target = lodestonePos;
            } else if (dimension.equals((Object)Dimension.field_236055_d_.func_240901_a_()) && CompassesWorkEverywhereModule.enableEnd) {
                calculate = true;
            } else if (dimension.equals((Object)Dimension.field_236054_c_.func_240901_a_()) && CompassAngleGetter.isCalculated(stack) && CompassesWorkEverywhereModule.enableNether) {
                boolean set = ItemNBTHelper.getBoolean((ItemStack)stack, (String)CompassAngleGetter.TAG_POSITION_SET, (boolean)false);
                if (set) {
                    int x = ItemNBTHelper.getInt((ItemStack)stack, (String)CompassAngleGetter.TAG_NETHER_TARGET_X, (int)0);
                    int z = ItemNBTHelper.getInt((ItemStack)stack, (String)CompassAngleGetter.TAG_NETHER_TARGET_Z, (int)0);
                    calculate = true;
                    target = new BlockPos(x, 0, z);
                }
            } else if (worldIn.func_230315_m_().func_236043_f_()) {
                calculate = true;
                target = this.getWorldSpawn(worldIn);
            }
            long gameTime = worldIn.func_82737_E();
            if (calculate && target != null) {
                double d1 = carried ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                double d2 = this.getAngleToPosition((Entity)entity, target) / (Math.PI * 2);
                if (carried) {
                    if (this.normalAngle.needsUpdate(gameTime)) {
                        this.normalAngle.wobble(gameTime, 0.5 - (d1 - 0.25));
                    }
                    angle = d2 + this.normalAngle.rotation;
                } else {
                    angle = 0.5 - (d1 - 0.25 - d2);
                }
            } else {
                if (this.unknownAngle.needsUpdate(gameTime)) {
                    this.unknownAngle.wobble(gameTime, Math.random());
                }
                angle = this.unknownAngle.rotation + (double)worldIn.hashCode() / Math.PI;
            }
            return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
        }

        private double getFrameRotation(ItemFrameEntity frame) {
            return MathHelper.func_76142_g((float)(180.0f + frame.func_174811_aO().func_185119_l()));
        }

        private double getAngleToPosition(Entity entity, BlockPos blockpos) {
            Vector3d pos = entity.func_213303_ch();
            return Math.atan2((double)blockpos.func_177952_p() - pos.field_72449_c, (double)blockpos.func_177958_n() - pos.field_72450_a);
        }

        @Nullable
        private BlockPos getLodestonePosition(World p_239442_1_, CompoundNBT p_239442_2_) {
            Optional optional;
            boolean flag = p_239442_2_.func_74764_b("LodestonePos");
            boolean flag1 = p_239442_2_.func_74764_b("LodestoneDimension");
            if (flag && flag1 && (optional = CompassItem.func_234667_a_((CompoundNBT)p_239442_2_)).isPresent() && p_239442_1_.func_234923_W_().equals(optional.get())) {
                return NBTUtil.func_186861_c((CompoundNBT)p_239442_2_.func_74775_l("LodestonePos"));
            }
            return null;
        }

        @Nullable
        private BlockPos getWorldSpawn(ClientWorld p_239444_1_) {
            return p_239444_1_.func_230315_m_().func_236043_f_() ? p_239444_1_.func_239140_u_() : null;
        }

        @OnlyIn(value=Dist.CLIENT)
        private static class Angle {
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            private Angle() {
            }

            private boolean needsUpdate(long p_239448_1_) {
                return this.lastUpdateTick != p_239448_1_;
            }

            private void wobble(long gameTime, double angle) {
                this.lastUpdateTick = gameTime;
                double d0 = angle - this.rotation;
                d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                this.rota += d0 * 0.1;
                this.rota *= 0.8;
                this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
            }
        }
    }
}

