/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.quark.content.world.module.underground.CaveCrystalUndergroundBiomeModule;

public class QuarkBeaconTileEntityRenderer {
    public static boolean render(BeaconTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!CaveCrystalUndergroundBiomeModule.staticEnabled || !CaveCrystalUndergroundBiomeModule.enableBeaconRedirection) {
            return false;
        }
        long i = tileEntityIn.func_145831_w().func_82737_E();
        List list = tileEntityIn.func_174907_n();
        for (int k = 0; k < list.size(); ++k) {
            BeaconTileEntity.BeamSegment segment = (BeaconTileEntity.BeamSegment)list.get(k);
            if (!(segment instanceof CaveCrystalUndergroundBiomeModule.ExtendedBeamSegment)) {
                return false;
            }
            QuarkBeaconTileEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, (CaveCrystalUndergroundBiomeModule.ExtendedBeamSegment)segment, partialTicks, i);
        }
        return true;
    }

    private static void renderBeamSegment(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, CaveCrystalUndergroundBiomeModule.ExtendedBeamSegment segment, float partialTicks, long totalWorldTime) {
        QuarkBeaconTileEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, BeaconTileEntityRenderer.field_147523_b, segment, partialTicks, 1.0f, totalWorldTime, 0.2f, 0.25f);
    }

    public static void renderBeamSegment(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ResourceLocation textureLocation, CaveCrystalUndergroundBiomeModule.ExtendedBeamSegment segment, float partialTicks, float textureScale, long totalWorldTime, float beamRadius, float glowRadius) {
        int height = segment.func_177264_c();
        float[] colors = segment.func_177263_b();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227861_a_((double)segment.offset.func_177958_n(), (double)segment.offset.func_177956_o(), (double)segment.offset.func_177952_p());
        matrixStackIn.func_227863_a_(segment.dir.func_229384_a_());
        float f = -((float)Math.floorMod(totalWorldTime, 40L) + partialTicks);
        float f2 = MathHelper.func_226164_h_((float)(0.2f - (float)MathHelper.func_76141_d((float)(f * 0.1f))));
        float f3 = colors[0];
        float f4 = colors[1];
        float f5 = colors[2];
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -beamRadius;
        float f12 = -beamRadius;
        float f15 = -1.0f + f2;
        float f16 = (float)height * textureScale * (0.5f / beamRadius) + f15;
        QuarkBeaconTileEntityRenderer.renderPart(matrixStackIn, bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)textureLocation, (boolean)false)), f3, f4, f5, 1.0f, height, 0.0f, beamRadius, beamRadius, 0.0f, f9, 0.0f, 0.0f, f12, 0.0f, 1.0f, f16, f15);
        matrixStackIn.func_227865_b_();
        f6 = -glowRadius;
        float f7 = -glowRadius;
        f8 = -glowRadius;
        f9 = -glowRadius;
        f15 = -1.0f + f2;
        f16 = (float)height * textureScale + f15;
        QuarkBeaconTileEntityRenderer.renderPart(matrixStackIn, bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)textureLocation, (boolean)true)), f3, f4, f5, 0.125f, height, f6, f7, glowRadius, f8, f9, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f16, f15);
        matrixStackIn.func_227865_b_();
    }

    private static void renderPart(MatrixStack matrixStackIn, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, int height, float p_228840_8_, float p_228840_9_, float p_228840_10_, float p_228840_11_, float p_228840_12_, float p_228840_13_, float p_228840_14_, float p_228840_15_, float u1, float u2, float v1, float v2) {
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        QuarkBeaconTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_8_, p_228840_9_, p_228840_10_, p_228840_11_, u1, u2, v1, v2);
        QuarkBeaconTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_14_, p_228840_15_, p_228840_12_, p_228840_13_, u1, u2, v1, v2);
        QuarkBeaconTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_10_, p_228840_11_, p_228840_14_, p_228840_15_, u1, u2, v1, v2);
        QuarkBeaconTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_12_, p_228840_13_, p_228840_8_, p_228840_9_, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        QuarkBeaconTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        QuarkBeaconTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        QuarkBeaconTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        QuarkBeaconTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.func_227888_a_(matrixPos, x, (float)y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

