/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.chunk;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IResizeCallback;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LithiumHashPalette<T>
implements IPalette<T> {
    private static final int ABSENT_VALUE = -1;
    private final ObjectIntIdentityMap<T> idList;
    private final IResizeCallback<T> resizeHandler;
    private final Function<CompoundNBT, T> elementDeserializer;
    private final Function<T, CompoundNBT> elementSerializer;
    private final int indexBits;
    private final Reference2IntMap<T> table;
    private T[] entries;
    private int size = 0;

    public LithiumHashPalette(ObjectIntIdentityMap<T> ids, int bits, IResizeCallback<T> resizeHandler, Function<CompoundNBT, T> deserializer, Function<T, CompoundNBT> serializer) {
        this.idList = ids;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        this.elementDeserializer = deserializer;
        this.elementSerializer = serializer;
        int capacity = 1 << bits;
        this.entries = new Object[capacity];
        this.table = new Reference2IntOpenHashMap(capacity, 0.5f);
        this.table.defaultReturnValue(-1);
    }

    public int func_186041_a(T obj) {
        int id = this.table.getInt(obj);
        if (id == -1) {
            id = this.computeEntry(obj);
        }
        return id;
    }

    private int computeEntry(T obj) {
        int id = this.addEntry(obj);
        if (id >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.onResize(this.indexBits + 1, obj);
        }
        return id;
    }

    private int addEntry(T obj) {
        int nextId = this.size;
        if (nextId >= this.entries.length) {
            this.resize(this.size);
        }
        this.table.put(obj, nextId);
        this.entries[nextId] = obj;
        ++this.size;
        return nextId;
    }

    private void resize(int neededCapacity) {
        this.entries = Arrays.copyOf(this.entries, HashCommon.nextPowerOfTwo((int)(neededCapacity + 1)));
    }

    public boolean func_230341_a_(Predicate<T> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.entries[i])) continue;
            return true;
        }
        return false;
    }

    public T func_186039_a(int id) {
        T[] entries = this.entries;
        if (id >= 0 && id < entries.length) {
            return entries[id];
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_186038_a(PacketBuffer buf) {
        this.clear();
        int entryCount = buf.func_150792_a();
        for (int i = 0; i < entryCount; ++i) {
            this.addEntry(this.idList.func_148745_a(buf.func_150792_a()));
        }
    }

    public void func_186037_b(PacketBuffer buf) {
        int size = this.size;
        buf.func_150787_b(size);
        for (int i = 0; i < size; ++i) {
            buf.func_150787_b(this.idList.func_148757_b(this.func_186039_a(i)));
        }
    }

    public int func_186040_a() {
        int size = PacketBuffer.func_150790_a((int)this.size);
        for (int i = 0; i < this.size; ++i) {
            size += PacketBuffer.func_150790_a((int)this.idList.func_148757_b(this.func_186039_a(i)));
        }
        return size;
    }

    public void func_196968_a(ListNBT list) {
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.addEntry(this.elementDeserializer.apply(list.func_150305_b(i)));
        }
    }

    public void toTag(ListNBT list) {
        for (int i = 0; i < this.size; ++i) {
            list.add((Object)((INBT)this.elementSerializer.apply(this.func_186039_a(i))));
        }
    }

    public int getSize() {
        return this.size;
    }

    private void clear() {
        Arrays.fill(this.entries, null);
        this.table.clear();
        this.size = 0;
    }
}

