/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.poi.fast_retrieval;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.util.Collector;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestCollectors;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionAccess;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.chunk.storage.RegionSectionCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PointOfInterestManager.class})
public abstract class PointOfInterestStorageMixin
extends RegionSectionCache<PointOfInterestData> {
    public PointOfInterestStorageMixin(File directory, Function<Runnable, Codec<PointOfInterestData>> function, Function<Runnable, PointOfInterestData> function2, DataFixer dataFixer, DefaultTypeReferences dataFixTypes, boolean bl) {
        super(directory, function, function2, dataFixer, dataFixTypes, bl);
    }

    @Overwrite
    public Stream<PointOfInterest> func_219137_a(Predicate<PointOfInterestType> predicate, ChunkPos pos, PointOfInterestManager.Status status) {
        return ((RegionBasedStorageSectionAccess)((Object)this)).getWithinChunkColumn(pos.field_77276_a, pos.field_77275_b).flatMap(set -> set.func_218247_a(predicate, status));
    }

    @Overwrite
    public Optional<BlockPos> func_219163_a(Predicate<PointOfInterestType> typePredicate, Predicate<BlockPos> posPredicate, PointOfInterestManager.Status status, BlockPos pos, int radius, Random rand) {
        List<PointOfInterest> list = this.getAllWithinCircle(typePredicate, pos, radius, status);
        Collections.shuffle(list, rand);
        for (PointOfInterest point : list) {
            if (!posPredicate.test(point.func_218261_f())) continue;
            return Optional.of(point.func_218261_f());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<BlockPos> func_234148_d_(Predicate<PointOfInterestType> predicate, BlockPos pos, int radius, PointOfInterestManager.Status status) {
        List<PointOfInterest> points = this.getAllWithinCircle(predicate, pos, radius, status);
        BlockPos nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (PointOfInterest point : points) {
            double distance = point.func_218261_f().func_177951_i((Vector3i)pos);
            if (!(distance < nearestDistance)) continue;
            nearest = point.func_218261_f();
            nearestDistance = distance;
        }
        return Optional.ofNullable(nearest);
    }

    @Overwrite
    public long func_219145_a(Predicate<PointOfInterestType> predicate, BlockPos pos, int radius, PointOfInterestManager.Status status) {
        return this.getAllWithinCircle(predicate, pos, radius, status).size();
    }

    private List<PointOfInterest> getAllWithinCircle(Predicate<PointOfInterestType> predicate, BlockPos pos, int radius, PointOfInterestManager.Status status) {
        ArrayList<PointOfInterest> points = new ArrayList<PointOfInterest>();
        this.collectWithinCircle(predicate, pos, radius, status, points::add);
        return points;
    }

    private void collectWithinCircle(Predicate<PointOfInterestType> predicate, BlockPos pos, int radius, PointOfInterestManager.Status status, Collector<PointOfInterest> collector) {
        Collector<PointOfInterest> filter = PointOfInterestCollectors.collectAllWithinRadius(pos, radius, collector);
        Collector<PointOfInterestData> consumer = PointOfInterestCollectors.collectAllMatching(predicate, status, filter);
        int minChunkX = pos.func_177958_n() - radius - 1 >> 4;
        int minChunkZ = pos.func_177952_p() - radius - 1 >> 4;
        int maxChunkX = pos.func_177958_n() + radius + 1 >> 4;
        int maxChunkZ = pos.func_177952_p() + radius + 1 >> 4;
        RegionBasedStorageSectionAccess storage = (RegionBasedStorageSectionAccess)((Object)this);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                if (storage.collectWithinChunkColumn(x, z, consumer)) continue;
                return;
            }
        }
    }
}

