/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.redstone_wire;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedstoneWireBlock.class})
public class RedstoneWireBlockMixin
extends Block {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Direction[] DIRECTIONS_VERTICAL = new Direction[]{Direction.DOWN, Direction.UP};
    private static final Direction[] DIRECTIONS_HORIZONTAL = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};
    private static final int MIN = 0;
    private static final int MAX = 15;
    private static final int MAX_WIRE = 14;

    public RedstoneWireBlockMixin(AbstractBlock.Properties settings) {
        super(settings);
    }

    @Inject(method={"getReceivedRedstonePower"}, cancellable=true, at={@At(value="HEAD")})
    private void getReceivedPowerFaster(World world, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.getReceivedPower(world, pos));
    }

    private int getReceivedPower(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        int power = 0;
        for (Direction dir : DIRECTIONS_VERTICAL) {
            BlockPos side = pos.func_177972_a(dir);
            BlockState neighbor = chunk.func_180495_p(side);
            if (neighbor.func_196958_f() || neighbor.func_203425_a((Block)this) || (power = Math.max(power, this.getPowerFromVertical(world, side, neighbor, dir))) < 15) continue;
            return 15;
        }
        BlockPos up = pos.func_177984_a();
        boolean checkWiresAbove = !chunk.func_180495_p(up).func_215686_e((IBlockReader)world, up);
        for (Direction dir : DIRECTIONS_HORIZONTAL) {
            if ((power = Math.max(power, this.getPowerFromSide(world, pos.func_177972_a(dir), dir, checkWiresAbove))) < 15) continue;
            return 15;
        }
        return power;
    }

    private int getPowerFromVertical(World world, BlockPos pos, BlockState state, Direction toDir) {
        int power = state.func_185911_a((IBlockReader)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.func_215686_e((IBlockReader)world, pos)) {
            return Math.max(power, this.getStrongPowerTo(world, pos, toDir.func_176734_d()));
        }
        return power;
    }

    private int getPowerFromSide(World world, BlockPos pos, Direction toDir, boolean checkWiresAbove) {
        BlockPos down;
        BlockState belowState;
        Chunk chunk = world.func_175726_f(pos);
        BlockState state = chunk.func_180495_p(pos);
        if (state.func_203425_a((Block)this)) {
            return (Integer)state.func_177229_b((Property)BlockStateProperties.field_208136_ak) - 1;
        }
        int power = state.func_185911_a((IBlockReader)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.func_215686_e((IBlockReader)world, pos)) {
            BlockPos up;
            BlockState aboveState;
            if ((power = Math.max(power, this.getStrongPowerTo(world, pos, toDir.func_176734_d()))) >= 15) {
                return 15;
            }
            if (checkWiresAbove && power < 14 && (aboveState = chunk.func_180495_p(up = pos.func_177984_a())).func_203425_a((Block)this)) {
                power = Math.max(power, (Integer)aboveState.func_177229_b((Property)BlockStateProperties.field_208136_ak) - 1);
            }
        } else if (power < 14 && (belowState = chunk.func_180495_p(down = pos.func_177977_b())).func_203425_a((Block)this)) {
            power = Math.max(power, (Integer)belowState.func_177229_b((Property)BlockStateProperties.field_208136_ak) - 1);
        }
        return power;
    }

    private int getStrongPowerTo(World world, BlockPos pos, Direction ignore) {
        int power = 0;
        for (Direction dir : DIRECTIONS) {
            BlockPos side;
            BlockState neighbor;
            if (dir == ignore || (neighbor = world.func_180495_p(side = pos.func_177972_a(dir))).func_196958_f() || neighbor.func_203425_a((Block)this) || (power = Math.max(power, neighbor.func_185893_b((IBlockReader)world, side, dir))) < 15) continue;
            return 15;
        }
        return power;
    }
}

