/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;

public class CarvingContext {
    private static final ThreadLocal<CarvingContext> CONTEXT = new ThreadLocal();
    private final ChunkPrimer chunkPrimer;
    private final WeakReference<ServerWorld> world;

    public CarvingContext(ServerWorld world, ChunkPrimer chunkPrimer) {
        this.world = new WeakReference<ServerWorld>(world);
        this.chunkPrimer = chunkPrimer;
    }

    public ServerWorld getWorld() {
        return (ServerWorld)this.world.get();
    }

    public BitSet getMask(GenerationStage.Carving stage) {
        return this.chunkPrimer.func_230345_b_(stage);
    }

    @Nullable
    public static CarvingContext pop() {
        CarvingContext context = CONTEXT.get();
        CONTEXT.set(null);
        return context;
    }

    @Nullable
    public static CarvingContext peek() {
        return CONTEXT.get();
    }

    public static void push(ServerWorld world, IChunk chunk) {
        if (chunk instanceof ChunkPrimer) {
            CONTEXT.set(new CarvingContext(world, (ChunkPrimer)chunk));
        } else if (chunk != null) {
            BetterCaves.LOGGER.error("ERROR: Attempted to push invalid IChunk implementation to CarvingContext: {}", chunk.getClass());
        }
    }
}

