/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.world.gen;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.world.gen.IRetroGen;
import org.cyclops.cyclopscore.world.gen.IRetroGenRegistry;

public class RetroGenRegistry
implements IRetroGenRegistry {
    private static RetroGenRegistry _instance = null;
    private final Set<IRetroGen> retroGeneratables = Sets.newHashSet();
    private final Random random = new Random();
    private final ModBase<?> mod;

    public RetroGenRegistry(ModBase mod) {
        this.mod = mod;
    }

    protected String getNBTTag() {
        return this.getMod().getModId() + "-RetroGen";
    }

    @Override
    public void registerRetroGen(IRetroGen retroGen) {
        this.retroGeneratables.add(retroGen);
    }

    @Override
    @SubscribeEvent
    public void retroGenLoad(ChunkDataEvent.Load event) {
        if (this.getMod().getReferenceValue(ModBase.REFKEY_RETROGEN).booleanValue() && event.getData() != null) {
            CompoundNBT tag = event.getData().func_74775_l(this.getNBTTag());
            if (tag == null) {
                tag = new CompoundNBT();
            }
            this.setChunkSeed(event.getWorld(), event.getChunk());
            boolean atLeastOneModified = false;
            for (IRetroGen retroGen : this.retroGeneratables) {
                if (!retroGen.shouldRetroGen(tag, event.getWorld().func_230315_m_())) continue;
                retroGen.retroGenerateChunk(tag, event.getChunk(), this.random);
                this.getMod().log(Level.INFO, "Retrogenerating chunk at " + event.getChunk().func_76632_l().field_77276_a + ":" + event.getChunk().func_76632_l().field_77275_b);
                atLeastOneModified = true;
            }
            if (atLeastOneModified) {
                event.getChunk().func_177427_f(true);
            }
        }
    }

    private void setChunkSeed(IWorld world, IChunk chunk) {
    }

    @Override
    @SubscribeEvent
    public void retroGenSave(ChunkDataEvent.Save event) {
        if (this.getMod().getReferenceValue(ModBase.REFKEY_RETROGEN).booleanValue() && event.getData() != null) {
            CompoundNBT tag = event.getData().func_74775_l(this.getNBTTag());
            if (tag == null) {
                tag = new CompoundNBT();
            }
            for (IRetroGen retroGen : this.retroGeneratables) {
                retroGen.afterRetroGen(tag);
            }
            event.getData().func_218657_a(this.getNBTTag(), (INBT)tag);
        }
    }

    public ModBase<?> getMod() {
        return this.mod;
    }
}

